/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ktde.model.ScalarModel;
import org.ktde.model.collections.CollectionModel;
import org.ktde.model.collections.wrapper.ModelIteratorWrapper;

public class CollectionModelWrapper<T>
implements Collection<T> {
    private CollectionModel<ScalarModel<T>> delegate;
    private ScalarModel<T> prototype;

    public CollectionModelWrapper(CollectionModel<ScalarModel<T>> delegate, ScalarModel<T> prototype) {
        this.delegate = delegate;
        this.prototype = prototype;
    }

    @Override
    public boolean add(T e) {
        return this.delegate.add(this.prototype.createInstance(e));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        ArrayList<ScalarModel<T>> conv = new ArrayList<ScalarModel<T>>();
        for (T e : c) {
            conv.add(this.prototype.createInstance(e));
        }
        return this.delegate.addAll(conv);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        for (ScalarModel scalarModel : this.delegate) {
            Object value = scalarModel.getValue();
            if ((value != null || o != null) && !value.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new ModelIteratorWrapper(this.delegate.iterator());
    }

    @Override
    public boolean remove(Object o) {
        for (ScalarModel scalarModel : this.delegate) {
            Object value = scalarModel.getValue();
            if ((value != null || o != null) && !value.equals(o)) continue;
            return this.delegate.remove(scalarModel);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = true;
        for (Object o : c) {
            result = result && this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] check;
        boolean result = true;
        for (Object element : check = this.toArray()) {
            ScalarModel o = (ScalarModel)element;
            if (c.contains(o.getValue())) continue;
            result = result && this.remove(o);
        }
        return result;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            a[i++] = iterator.next();
        }
        return a;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        int i = 0;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T t;
            T s = t = iterator.next();
            a[i++] = s;
        }
        return a;
    }
}

