/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.ktde.model.Model;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.model.collections.AbstractCollectionModel;
import org.ktde.model.collections.IterableCollectionModel;
import org.ktde.util.cache.TwoLevelCache;
import org.ktde.util.function.DefaultConstantFunction;
import org.ktde.util.function.Function;

public class ListModel<T extends Model>
extends AbstractCollectionModel<T>
implements IterableCollectionModel<T>,
List<T>,
ValueChangeListener {
    private List<T> elements = new ArrayList<T>();
    private Function<Boolean> canSet;
    private Function<Boolean> canEdit;

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void performAppend(T value) {
        this.elements.add(value);
        value.addValueChangeListener(this);
    }

    @Override
    public boolean canSet(int index, T value) {
        HashMap variables = new HashMap();
        variables.put("index", new DefaultConstantFunction<Integer>(index));
        variables.put("object", new DefaultConstantFunction<T>(this.elements.get(index)));
        variables.put("newobject", new DefaultConstantFunction<T>(value));
        return this.canSet.evaluate(variables);
    }

    @Override
    public boolean canEdit(int index) {
        HashMap variables = new HashMap();
        variables.put("index", new DefaultConstantFunction<Integer>(index));
        variables.put("object", new DefaultConstantFunction<T>(this.elements.get(index)));
        return this.canEdit.evaluate(variables);
    }

    @Override
    public T get(int index) {
        return (T)((Model)this.elements.get(index));
    }

    @Override
    public T set(int index, T value) {
        if (index < this.elements.size()) {
            ((Model)this.elements.get(index)).removeValueChangeListener(this);
        }
        this.elements.set(index, value);
        value.addValueChangeListener(this);
        this.fireValueChanged(this, null);
        return value;
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    protected void performDelete(T element) {
        element.removeValueChangeListener(this);
        this.elements.remove(element);
    }

    @Override
    public boolean canDelete(int index) {
        return this.canDelete(this.elements.get(index));
    }

    public void setCanSet(Function<Boolean> canSet) {
        this.canSet = canSet;
    }

    public Function<Boolean> getCanSet() {
        return this.canSet;
    }

    public void setCanEdit(Function<Boolean> canEdit) {
        this.canEdit = canEdit;
    }

    public Function<Boolean> getCanEdit() {
        return this.canEdit;
    }

    @Override
    public void delete(int index) {
        ((Model)this.elements.get(index)).removeValueChangeListener(this);
        this.elements.remove(index);
        this.fireValueChanged(this, null);
        this.changeSize();
    }

    @Override
    public void add(int index, T element) {
        if (this.canAppend(element)) {
            this.elements.add(index, element);
            element.addValueChangeListener(this);
            this.fireValueChanged(this, null);
            this.changeSize();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return false;
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public T remove(int index) {
        Model result = null;
        if (this.canDelete(index)) {
            ((Model)this.elements.get(index)).removeValueChangeListener(this);
            result = (Model)this.elements.remove(index);
            this.fireValueChanged(this, null);
            this.changeSize();
        }
        return (T)result;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ListModel<T> submodel = new ListModel<T>();
        submodel.elements = this.elements.subList(fromIndex, toIndex);
        return submodel;
    }

    @Override
    public void valueChanged(ValueChangeEvent e) {
        this.fireValueChangeEvent(e);
    }

    @Override
    public ListModel<T> getEditableClone(TwoLevelCache<Class<? extends Model>, Long, Model> cache) {
        ListModel<Model> editableClone = new ListModel<Model>();
        editableClone.setCanAppendAnonymous(this.getCanAppendAnonymous());
        editableClone.setCanAppendObject(this.getCanAppendObject());
        editableClone.setCanEdit(this.getCanEdit());
        editableClone.setCanDelete(this.getCanDelete());
        editableClone.setCanSet(this.getCanSet());
        for (Model model : this.elements) {
            editableClone.add(model.getEditableClone(cache));
        }
        return editableClone;
    }
}

