/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.model.collections.AbstractCollectionModel;
import org.ktde.model.collections.IterableCollectionModel;

public abstract class AbstractUnsortedCollectionModel<T>
extends AbstractCollectionModel<T>
implements IterableCollectionModel<T> {
    private List<T> sortedList;
    private Comparator<T> comparator;
    private boolean sorted;

    public AbstractUnsortedCollectionModel() {
        this(new DefaultComparator());
    }

    public AbstractUnsortedCollectionModel(Comparator<T> comparator) {
        this.comparator = comparator;
        this.sorted = false;
    }

    public abstract Collection<T> getAsCollection();

    public synchronized void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
        this.sorted = false;
        this.sort();
    }

    public synchronized void sort() {
        Collection<T> collection = this.getAsCollection();
        if (this.sortedList == null) {
            this.sortedList = new ArrayList<T>(collection.size());
        } else {
            this.sortedList.clear();
        }
        this.sortedList.addAll(collection);
        Collections.sort(this.sortedList, this.comparator);
        this.sorted = true;
    }

    @Override
    public T get(int index) {
        if (!this.sorted) {
            this.sort();
        }
        return this.sortedList.get(index);
    }

    @Override
    public final T set(int index, T value) {
        this.set(this.get(index), value);
        return value;
    }

    protected abstract void set(T var1, T var2);

    protected abstract boolean canSet(T var1, T var2);

    protected abstract boolean canEdit(T var1);

    @Override
    public void delete(int index) {
        this.delete(this.get(index));
    }

    @Override
    public boolean canDelete(int index) {
        return this.canDelete(this.get(index));
    }

    @Override
    public boolean canEdit(int index) {
        return this.canEdit(this.get(index));
    }

    @Override
    public final boolean canSet(int index, T value) {
        return this.canSet(this.get(index), value);
    }

    private static class DefaultComparator
    implements Comparator<Object> {
        DefaultComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.hashCode() - o2.hashCode();
        }
    }
}

