/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model;

import java.util.EventObject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ValueChangeEvent
extends EventObject {
    private static final long serialVersionUID = -7732777340945660160L;
    private Object newValue;
    private Object oldValue;
    private Enum<?> property;
    private Type type;

    public ValueChangeEvent(Object source, Type type, Object newValue, Object oldValue, Enum<?> property) {
        super(source);
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.type = type;
        this.property = property;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Type getType() {
        return this.type;
    }

    public Enum<?> getProperty() {
        return this.property;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueChangeEvent) {
            ValueChangeEvent other = (ValueChangeEvent)obj;
            return new EqualsBuilder().append(this.getSource(), other.getSource()).append((Object)this.getType(), (Object)other.getType()).append(this.getProperty(), other.getProperty()).append(this.getOldValue(), other.getOldValue()).append(this.getNewValue(), other.getOldValue()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getSource()).append((Object)this.getType()).append(this.getProperty()).append(this.getOldValue()).append(this.getNewValue()).toHashCode();
    }

    public static ValueChangeEvent createCreationModelValueChangeEvent(Object source) {
        return new ValueChangeEvent(source, Type.INSERT, null, null, null);
    }

    public static ValueChangeEvent createDeletionModelValueChangeEvent(Object source) {
        return new ValueChangeEvent(source, Type.DELETE, null, null, null);
    }

    public static ValueChangeEvent createUndeletionModelValueChangeEvent(Object source) {
        return new ValueChangeEvent(source, Type.UNDELETE, null, null, null);
    }

    public static ValueChangeEvent createUpdateModelValueChangeEvent(Object source, Enum<?> property, Object oldValue, Object newValue) {
        return new ValueChangeEvent(source, Type.UPDATE, newValue, oldValue, property);
    }

    public static enum Type {
        DELETE,
        INSERT,
        UPDATE,
        UNDELETE;

    }
}

