/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.model;

import org.ktde.model.AbstractModel;
import org.ktde.model.Model;
import org.ktde.model.ScalarModel;
import org.ktde.util.cache.TwoLevelCache;

public abstract class AbstractScalarModel<T>
extends AbstractModel
implements ScalarModel<T>,
Cloneable {
    private static final long serialVersionUID = 946927460195418117L;
    private T value;

    public AbstractScalarModel(T value) {
        this.value = value;
    }

    public AbstractScalarModel() {
        this.value = this.getDefault();
    }

    protected T getDefault() {
        return this.getEmpty();
    }

    protected abstract T getEmpty();

    @Override
    public synchronized void setValue(T value) {
        if (value == null) {
            value = this.getEmpty();
        }
        if (!this.value.equals(value)) {
            this.setDirty(true);
            T oldValue = this.value;
            this.value = value;
            this.fireValueChanged(this.value, oldValue);
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof AbstractScalarModel)) {
            return false;
        }
        AbstractScalarModel otherScalar = (AbstractScalarModel)other;
        return this.value == null ? otherScalar.value == null : otherScalar.value != null && this.value.getClass() == otherScalar.value.getClass() && this.value.equals(otherScalar.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    public ScalarModel<T> clone() {
        return this.createInstance(this.value);
    }

    @Override
    public ScalarModel<T> getEditableClone(TwoLevelCache<Class<? extends Model>, Long, Model> cache) {
        return this.clone();
    }
}

