/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class Wgs84Factory
extends GeoDecimalFactory {
    private static final long serialVersionUID = 7680253691168987712L;
    public static final Wgs84Factory INSTANCE = new Wgs84Factory();

    public Wgs84Factory() {
        super(1.0);
    }

    @Override
    public int getEpsg() {
        return 4326;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Wgs84;
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public String getStringX(Coordinate c) {
        double d = c.getX();
        return this.formatDouble(d);
    }

    private String formatDouble(double d) {
        if (d == 0.0) {
            return "0.000000";
        }
        long l = Math.round(d *= 1000000.0);
        String s = Long.toString(l);
        int length = s.length();
        return s.substring(0, length - 6) + "." + s.substring(length - 6, length);
    }

    @Override
    public String getStringY(Coordinate c) {
        return this.formatDouble(c.getY());
    }
}

