/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.AbstractPotsdamBasedCoordinateFactory;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.util.datatypes.Tupel;

public class PotsdamCoordinateFactory
extends AbstractPotsdamBasedCoordinateFactory {
    private static final long serialVersionUID = -4558531977168445551L;
    public static final CoordinateFactory INSTANCE = new PotsdamCoordinateFactory();

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        Tupel<Double, Double> tupel = PotsdamCoordinateFactory.potToWgs84(coordinate.getX(), coordinate.getY());
        return new Coordinate(GeoDecimalFactory.INSTANCE, tupel.getElement1() * 100000.0, tupel.getElement2() * 100000.0, coordinate.getZ());
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        Tupel<Double, Double> tupel = this.wgs84ToPot(coordinate.getX() / 100000.0, coordinate.getY() / 100000.0);
        return INSTANCE.createCoordinate(tupel.getElement1(), tupel.getElement2());
    }

    public String toString() {
        return "Potsdam";
    }

    @Override
    public int getEpsg() {
        return -1;
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Potsdam;
    }

    @Override
    public boolean isListable() {
        return false;
    }
}

