/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;

public class Lv95CoordinateFactory
extends CoordinateFactory {
    private static final long serialVersionUID = 8292646967890720734L;
    public static final Lv95CoordinateFactory INSTANCE = new Lv95CoordinateFactory();

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double x = coordinate.getX();
        double y = coordinate.getY();
        double y1 = (x - 2600000.0) / 1000000.0;
        double x1 = (y - 1200000.0) / 1000000.0;
        double lambda = 2.6779094 + 4.728982 * y1 + 0.791484 * y1 * x1 + 0.1306 * y1 * x1 * x1 - 0.0436 * y1 * y1 * y1;
        double phi = 16.9023892 + 3.238272 * x1 - 0.270978 * y1 * y1 - 0.002528 * x1 * x1 - 0.0447 * y1 * y1 * x1 - 0.014 * x1 * x1 * x1;
        lambda = lambda * 100.0 / 36.0;
        phi = phi * 100.0 / 36.0;
        return new Coordinate(GeoDecimalFactory.INSTANCE, lambda *= 100000.0, phi *= 100000.0);
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        double lambda = coordinate.getX() / 100000.0;
        double phi = coordinate.getY() / 100000.0;
        phi = this.toSeconds(phi);
        lambda = this.toSeconds(lambda);
        phi = (phi - 169028.66) / 10000.0;
        lambda = (lambda - 26782.5) / 10000.0;
        double x = 2600072.37 + 211455.93 * lambda - 10938.51 * lambda * phi - 0.36 * lambda * phi * phi - 44.54 * lambda * lambda * lambda;
        double y = 1200147.07 + 308807.95 * phi + 3745.25 * lambda * lambda + 76.63 * phi * phi - 194.56 * lambda * lambda * phi + 119.79 * phi * phi * phi;
        return new Coordinate(this, x, y);
    }

    private double toSeconds(double value) {
        double degrees = Math.floor(value);
        double minutes = Math.floor(60.0 * (value - degrees));
        double seconds = 3600.0 * (value - degrees) - 60.0 * minutes;
        return seconds + minutes * 60.0 + degrees * 3600.0;
    }

    @Override
    public int getEpsg() {
        return 0;
    }

    @Override
    public double getRefScale() {
        return 0.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Lv95;
    }

    @Override
    public boolean isListable() {
        return true;
    }

    @Override
    public String getName() {
        return CoordinateFactory.Projections.Lv95.name();
    }
}

