/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.math.projection.generic.Etrs89Utm32NFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class KatasterCoordinateFactory
extends Etrs89Utm32NFactory {
    private static final long serialVersionUID = 8025025111424032613L;
    public static KatasterCoordinateFactory INSTANCE;

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        double x = coordinate.getX();
        double zone = Math.floor(x / 1000000.0);
        return super.transformToGeoDecimal(INSTANCE.createCoordinate(x -= (zone *= 1000000.0), coordinate.getY()));
    }

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        Coordinate c = super.transformFromGeoDecimal(coordinate);
        double x = c.getX();
        c = Wgs84Factory.INSTANCE.createCoordinate(x += 3.2E7, c.getY());
        return c;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.Kataster;
    }

    static {
        try {
            INSTANCE = new KatasterCoordinateFactory();
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

