/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import org.ktde.math.projection.AbstractPotsdamBasedCoordinateFactory;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimalFactory;
import org.ktde.util.datatypes.Tupel;

public class GaussKruegerFactory
extends AbstractPotsdamBasedCoordinateFactory {
    private static final long serialVersionUID = -5793793410850646144L;
    public static final GaussKruegerFactory INSTANCE = new GaussKruegerFactory();

    @Override
    protected Coordinate transformFromGeoDecimal(Coordinate coordinate) {
        Tupel<Double, Double> tupel = this.wgs84ToPot(coordinate.getX() / 100000.0, coordinate.getY() / 100000.0);
        tupel = this.pot2Gk(tupel.getElement1(), tupel.getElement2());
        return INSTANCE.createCoordinate(tupel.getElement1(), tupel.getElement2());
    }

    private Tupel<Double, Double> gk2Pot(double rw, double hw) {
        double a = 6377397.155;
        double f = 0.00334277321;
        double pi = Math.PI;
        double c = a / (1.0 - f);
        double ex2 = (2.0 * f - f * f) / ((1.0 - f) * (1.0 - f));
        double ex4 = ex2 * ex2;
        double ex6 = ex4 * ex2;
        double ex8 = ex4 * ex4;
        double e0 = c * (pi / 180.0) * (1.0 - 3.0 * ex2 / 4.0 + 45.0 * ex4 / 64.0 - 175.0 * ex6 / 256.0 + 11025.0 * ex8 / 16384.0);
        double f2 = 180.0 / pi * (3.0 * ex2 / 8.0 - 3.0 * ex4 / 16.0 + 213.0 * ex6 / 2048.0 - 255.0 * ex8 / 4096.0);
        double f4 = 180.0 / pi * (21.0 * ex4 / 256.0 - 21.0 * ex6 / 256.0 + 533.0 * ex8 / 8192.0);
        double f6 = 180.0 / pi * (151.0 * ex6 / 6144.0 - 453.0 * ex8 / 12288.0);
        double sigma = hw / e0;
        double sigmr = sigma * pi / 180.0;
        double bf = sigma + f2 * Math.sin(2.0 * sigmr) + f4 * Math.sin(4.0 * sigmr) + f6 * Math.sin(6.0 * sigmr);
        double br = bf * pi / 180.0;
        double tan1 = Math.tan(br);
        double tan2 = tan1 * tan1;
        double tan4 = tan2 * tan2;
        double cos1 = Math.cos(br);
        double cos2 = cos1 * cos1;
        double etasq = ex2 * cos2;
        double nd = c / Math.sqrt(1.0 + etasq);
        double nd2 = nd * nd;
        double nd4 = nd2 * nd2;
        double nd6 = nd4 * nd2;
        double nd3 = nd2 * nd;
        double nd5 = nd4 * nd;
        double kz = Math.floor(rw / 1000000.0);
        double lh = kz * 3.0;
        double dy = rw - (kz * 1000000.0 + 500000.0);
        double dy2 = dy * dy;
        double dy4 = dy2 * dy2;
        double dy3 = dy2 * dy;
        double dy5 = dy4 * dy;
        double dy6 = dy3 * dy3;
        double b2 = -tan1 * (1.0 + etasq) / (2.0 * nd2);
        double b4 = tan1 * (5.0 + 3.0 * tan2 + 6.0 * etasq * (1.0 - tan2)) / (24.0 * nd4);
        double b6 = -tan1 * (61.0 + 90.0 * tan2 + 45.0 * tan4) / (720.0 * nd6);
        double l1 = 1.0 / (nd * cos1);
        double l3 = -(1.0 + 2.0 * tan2 + etasq) / (6.0 * nd3 * cos1);
        double l5 = (5.0 + 28.0 * tan2 + 24.0 * tan4) / (120.0 * nd5 * cos1);
        double bp = bf + 180.0 / pi * (b2 * dy2 + b4 * dy4 + b6 * dy6);
        double lp = lh + 180.0 / pi * (l1 * dy + l3 * dy3 + l5 * dy5);
        return new Tupel<Double, Double>(lp, bp);
    }

    private Tupel<Double, Double> pot2Gk(double lp, double bp) {
        double a = 6377397.155;
        double f = 0.00334277321;
        double pi = Math.PI;
        double c = a / (1.0 - f);
        double ex2 = (2.0 * f - f * f) / ((1.0 - f) * (1.0 - f));
        double ex4 = ex2 * ex2;
        double ex6 = ex4 * ex2;
        double ex8 = ex4 * ex4;
        double e0 = c * (pi / 180.0) * (1.0 - 3.0 * ex2 / 4.0 + 45.0 * ex4 / 64.0 - 175.0 * ex6 / 256.0 + 11025.0 * ex8 / 16384.0);
        double e2 = c * (-3.0 * ex2 / 8.0 + 15.0 * ex4 / 32.0 - 525.0 * ex6 / 1024.0 + 2205.0 * ex8 / 4096.0);
        double e4 = c * (15.0 * ex4 / 256.0 - 105.0 * ex6 / 1024.0 + 2205.0 * ex8 / 16384.0);
        double e6 = c * (-35.0 * ex6 / 3072.0 + 315.0 * ex8 / 12288.0);
        double br = bp * pi / 180.0;
        double tan1 = Math.tan(br);
        double tan2 = tan1 * tan1;
        double tan4 = tan2 * tan2;
        double cos1 = Math.cos(br);
        double cos2 = cos1 * cos1;
        double cos4 = cos2 * cos2;
        double cos3 = cos2 * cos1;
        double cos5 = cos4 * cos1;
        double etasq = ex2 * cos2;
        double nd = c / Math.sqrt(1.0 + etasq);
        double g = e0 * bp + e2 * Math.sin(2.0 * br) + e4 * Math.sin(4.0 * br) + e6 * Math.sin(6.0 * br);
        double kz = Math.floor(lp / 3.0);
        double lh = kz * 3.0;
        double dl = (lp - lh) * pi / 180.0;
        double dl2 = dl * dl;
        double dl4 = dl2 * dl2;
        double dl3 = dl2 * dl;
        double dl5 = dl4 * dl;
        double hw = g + nd * cos2 * tan1 * dl2 / 2.0 + nd * cos4 * tan1 * (5.0 - tan2 + 9.0 * etasq) * dl4 / 24.0;
        double rw = nd * cos1 * dl + nd * cos3 * (1.0 - tan2 + etasq) * dl3 / 6.0 + nd * cos5 * (5.0 - 18.0 * tan2 + tan4) * dl5 / 120.0 + kz * 1000000.0 + 500000.0;
        return new Tupel<Double, Double>(rw, hw);
    }

    @Override
    protected Coordinate transformToGeoDecimal(Coordinate coordinate) {
        Tupel<Double, Double> tupel = this.gk2Pot(coordinate.getX(), coordinate.getY());
        tupel = GaussKruegerFactory.potToWgs84(tupel.getElement1(), tupel.getElement2());
        return new Coordinate(GeoDecimalFactory.INSTANCE, tupel.getElement1() * 100000.0, tupel.getElement2() * 100000.0, coordinate.getZ());
    }

    public String toString() {
        return "Gauss-Krueger";
    }

    @Override
    public int getEpsg() {
        return -1;
    }

    @Override
    public double getRefScale() {
        return 1.0;
    }

    @Override
    public CoordinateFactory.Projections getProjection() {
        return CoordinateFactory.Projections.GaussKrueger;
    }

    @Override
    public boolean isListable() {
        return true;
    }
}

