/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.projection;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.Wgs84Factory;

public class Coordinate
implements Serializable {
    private static final long serialVersionUID = -1509906176578307943L;
    private CoordinateFactory factory;
    private double x;
    private double y;
    private double z;

    public Coordinate(CoordinateFactory factory, double x, double y) {
        this(factory, x, y, 0.0);
    }

    public Coordinate(CoordinateFactory factory, double x, double y, double z) {
        this.factory = factory;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public CoordinateFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.factory.toString() + " Coordinate(" + this.x + "/" + this.y + "/" + this.z + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinate) {
            Coordinate other = (Coordinate)obj;
            return this.factory.equals(other.factory) && this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.x).append(this.y).append(this.z).toHashCode();
    }

    public Coordinate transformed(AffineTransform transform) {
        Point2D.Double in = new Point2D.Double(this.x, this.y);
        Point2D.Double out = new Point2D.Double();
        transform.transform(in, out);
        return new Coordinate(this.factory, ((Point2D)out).getX(), ((Point2D)out).getY(), this.z);
    }

    public static boolean equalsCoordinateLocation(Coordinate c1, Coordinate c2) {
        return Coordinate.equalsCoordinateLocation(c1, c2, GeoDecimal100Factory.INSTANCE);
    }

    public static boolean equalsCoordinateLocation(Coordinate c1, Coordinate c2, CoordinateFactory comparing, double toleranceX, double toleranceY) {
        double y2;
        double x2;
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        Coordinate t1 = comparing.createCoordinate(c1);
        Coordinate t2 = comparing.createCoordinate(c2);
        double x1 = t1.getX();
        double m = Math.abs(x1 - (x2 = t2.getX()));
        if (m > toleranceX) {
            return false;
        }
        double y1 = t1.getY();
        m = Math.abs(y1 - (y2 = t2.getY()));
        return !(m > toleranceY);
    }

    public static boolean equalsCoordinateLocation(Coordinate c1, Coordinate c2, CoordinateFactory comparing) {
        return Coordinate.equalsCoordinateLocation(c1, c2, comparing, 0.0, 0.0);
    }

    public Coordinate correctToEarth() {
        double y;
        double x;
        Coordinate coordinate = Wgs84Factory.INSTANCE.createCoordinate(this);
        for (x = coordinate.getX(); x > 180.0; x -= 360.0) {
        }
        while (x <= -180.0) {
            x += 360.0;
        }
        for (y = coordinate.getY(); y > 180.0; y -= 360.0) {
        }
        while (y <= -180.0) {
            y += 360.0;
        }
        coordinate = Wgs84Factory.INSTANCE.createCoordinate(x, y);
        return this.getFactory().createCoordinate(coordinate);
    }

    public String getXString() {
        return this.factory.getStringX(this);
    }

    public String getYString() {
        return this.factory.getStringY(this);
    }
}

