/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.util.Vector;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedNumber;
import org.ktde.math.number.RootNumber;
import org.ktde.util.datatypes.Tupel;

public class SymbolNumber
extends PartedNumber {
    private String symbol;

    public SymbolNumber(String symbol) {
        super(symbol);
        this.symbol = symbol;
    }

    public SymbolNumber(char c) {
        this("" + c);
    }

    public static SymbolNumber createSymbol(String symbol) {
        return new SymbolNumber(symbol);
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == SymbolNumber.class && ((SymbolNumber)o).symbol.equals(this.symbol);
    }

    @Override
    public IntegerFraction getFactor() {
        return IntegerNumber.ONE;
    }

    @Override
    public Vector<Tupel<SymbolNumber, IntegerNumber>> getParts() {
        Vector<Tupel<SymbolNumber, IntegerNumber>> v = new Vector<Tupel<SymbolNumber, IntegerNumber>>(1);
        v.addElement(new Tupel<SymbolNumber, IntegerNumber>(this, IntegerNumber.ONE));
        return v;
    }

    @Override
    public int compareTo(Numeric o) {
        int comp = o instanceof SymbolNumber ? this.symbol.compareTo(((SymbolNumber)o).symbol) : -1;
        return comp;
    }

    @Override
    public PartedNumber negate() {
        return (PartedNumber)PartedNumber.createPartedNumber(IntegerNumber.MINUSONE, this, IntegerNumber.ONE);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Numeric solveEqual(Numeric numeric, SymbolNumber by) {
        if (numeric instanceof IntegerFraction) {
            if (this.symbol.equals(by.symbol)) {
                return numeric;
            }
            return by;
        }
        if (numeric instanceof RootNumber) {
            return this.pow(((RootNumber)numeric).getRoot()).solveEqual(((RootNumber)numeric).getBase(), by);
        }
        if (numeric instanceof SymbolNumber) {
            if (this.symbol.equals(by.symbol)) {
                return numeric;
            }
            return by;
        }
        return numeric.solveEqual(this, by);
    }

    @Override
    public Numeric ggT(Numeric n) {
        Numeric result = n instanceof RootNumber ? IntegerNumber.ONE : (n instanceof SymbolNumber ? (n.toString().equals(this.toString()) ? this : n.ggT(this)) : n.ggT(this));
        return result;
    }
}

