/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.math.BigDecimal;
import java.util.Vector;
import org.ktde.math.number.ComparableNumeric;
import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.PartedNumber;
import org.ktde.math.number.PartedNumberSum;
import org.ktde.math.number.SymbolNumber;
import org.ktde.util.datatypes.Tupel;

public class RootNumber
extends SymbolNumber
implements ComparableNumeric {
    private PartedFraction base;
    private IntegerNumber root;

    protected RootNumber(String tostring) {
        super(tostring);
    }

    private RootNumber(PartedFraction base, IntegerNumber root) {
        this("rt" + root + "(" + base + ")");
        this.base = base;
        this.root = root;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerFraction) {
            result = PartedNumber.createPartedNumber((IntegerFraction)numeric, this, IntegerNumber.ONE);
        } else if (numeric instanceof RootNumber) {
            if (((RootNumber)numeric).getRoot().equals(this.getRoot())) {
                result = RootNumber.createRootNumber((PartedFraction)this.getBase().multiply(((RootNumber)numeric).getBase()), this.getRoot());
            } else if (((RootNumber)numeric).getBase().equals(this.getBase())) {
                result = RootNumber.createRootNumber(this.getBase(), (IntegerFraction)this.getRoot().add(((RootNumber)numeric).getRoot()));
            } else {
                Vector<Tupel<SymbolNumber, IntegerNumber>> newParts = new Vector<Tupel<SymbolNumber, IntegerNumber>>(2);
                newParts.addElement(new Tupel<RootNumber, IntegerNumber>(this, IntegerNumber.ONE));
                newParts.addElement(new Tupel<SymbolNumber, IntegerNumber>((SymbolNumber)numeric, IntegerNumber.ONE));
                result = PartedNumber.createPartedNumber(newParts);
            }
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result = numeric instanceof IntegerFraction ? PartedNumber.createPartedNumber((IntegerFraction)numeric.reciprocal(), this, IntegerNumber.ONE) : (numeric instanceof RootNumber ? (((RootNumber)numeric).getRoot().equals(this.getRoot()) ? RootNumber.createRootNumber((PartedFraction)this.getBase().divide(((RootNumber)numeric).getBase()), this.getRoot()) : (((RootNumber)numeric).getBase().equals(this.getBase()) ? RootNumber.createRootNumber(this.getBase(), (IntegerFraction)this.getRoot().sub(((RootNumber)numeric).getRoot())) : PartedFraction.createFraction(this, (RootNumber)numeric))) : numeric.divide(this).reciprocal());
        return result;
    }

    @Override
    public Numeric ggT(Numeric n) {
        Numeric result = n instanceof IntegerFraction ? IntegerNumber.ONE : (n instanceof RootNumber ? (((RootNumber)n).getRoot().equals(this.getRoot()) ? RootNumber.createRootNumber((PartedFraction)this.getBase().ggT(((RootNumber)n).getBase()), this.getRoot()) : IntegerNumber.ONE) : n.ggT(this));
        return result;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        RootNumber result = this;
        if (numeric instanceof RootNumber && ((RootNumber)numeric).getRoot().equals(this.getRoot()) && this.getBase().modulo(((RootNumber)numeric).getBase()).equals(IntegerNumber.ZERO)) {
            result = IntegerNumber.ZERO;
        }
        return result;
    }

    @Override
    public PartedFraction reciprocal() {
        return PartedFraction.createFraction(IntegerNumber.ONE, this);
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == RootNumber.class && ((RootNumber)o).getBase().equals(this.getBase()) && ((RootNumber)o).getRoot().equals(this.getRoot());
    }

    @Override
    public PartedNumber negate() {
        return (PartedNumber)PartedNumber.createPartedNumber(IntegerNumber.MINUSONE, this, IntegerNumber.ONE);
    }

    @Override
    public int compareTo(ComparableNumeric o) {
        int comp = 0;
        if (o instanceof IntegerFraction) {
            comp = ((RootNumber)this.getBase()).compareTo(((IntegerFraction)o).pow(this.getRoot().reciprocal()));
        } else if (o instanceof RootNumber) {
            comp = ((RootNumber)this.getBase().pow(((RootNumber)o).getRoot())).compareTo(((RootNumber)o).getBase().pow(this.getRoot()));
        } else if (o instanceof ComparableNumeric) {
            comp = -o.compareTo(this);
        }
        return comp;
    }

    @Override
    public boolean isNegative() {
        return this.getBase().isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.getBase().isPositive();
    }

    @Override
    public RootNumber abs() {
        return (RootNumber)RootNumber.createRootNumber(this.getBase().abs(), this.getRoot());
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        IntegerFraction newroot = (IntegerFraction)this.getRoot().divide(exponent);
        ComplexNumber result = RootNumber.createRootNumber(this.getBase(), newroot);
        return result;
    }

    public static ComplexNumber createRootNumber(ComplexNumber number, IntegerFraction root) {
        ComplexNumber result;
        if (root.compareTo(IntegerNumber.ZERO) == 0) {
            result = IntegerNumber.ONE;
        } else if (root.isNegative()) {
            result = RootNumber.createRootNumber(number.reciprocal(), root.negate());
        } else if (root instanceof IntegerNumber) {
            if (number instanceof IntegerFraction) {
                if (((IntegerFraction)number).isNegative()) {
                    if (root.equals(IntegerNumber.TWO)) {
                        result = ComplexNumber.createComplexNumber(IntegerNumber.ZERO, (RootNumber)RootNumber.createRootNumber(number.negate(), root));
                    } else {
                        if (((IntegerNumber)root).isEven()) {
                            throw new RuntimeException("Complex generation not yet implemented");
                        }
                        result = PartedNumber.createPartedNumber(IntegerNumber.MINUSONE, (RootNumber)RootNumber.createRootNumber(number.negate(), root), IntegerNumber.ONE);
                    }
                } else {
                    result = new RootNumber((IntegerNumber)number, (IntegerNumber)root);
                }
            } else if (number instanceof RootNumber) {
                result = RootNumber.createRootNumber(((RootNumber)number).getBase(), (IntegerNumber)root.multiply(((RootNumber)number).getRoot()));
            } else if (number instanceof SymbolNumber) {
                result = new RootNumber((SymbolNumber)number, (IntegerNumber)root);
            } else if (number instanceof PartedNumber) {
                Vector<Tupel<SymbolNumber, IntegerNumber>> parts = ((PartedNumber)number).getParts();
                result = RootNumber.createRootNumber(((PartedNumber)number).getFactor(), root);
                for (Tupel<SymbolNumber, IntegerNumber> part : parts) {
                    result = (ComplexNumber)result.multiply(RootNumber.createRootNumber(part.getElement1(), (IntegerFraction)root.divide(part.getElement2())));
                }
            } else {
                result = number instanceof PartedNumberSum ? new RootNumber((PartedNumberSum)number, (IntegerNumber)root) : (number instanceof PartedFraction ? (ComplexNumber)RootNumber.createRootNumber(((PartedFraction)number).getNumerator(), root).divide(RootNumber.createRootNumber(((PartedFraction)number).getDenominator(), root)) : null);
            }
        } else {
            result = RootNumber.createRootNumber(number.pow(root.getDenominator()), root.getNumerator());
        }
        return result;
    }

    public PartedFraction getBase() {
        return this.base;
    }

    public IntegerNumber getRoot() {
        return this.root;
    }

    @Override
    public Numeric solveEqual(Numeric numeric, SymbolNumber by) {
        if (numeric instanceof RootNumber) {
            return this.getBase().pow(((RootNumber)numeric).getRoot()).solveEqual(((RootNumber)numeric).getBase().pow(this.getRoot()), by);
        }
        return numeric.solveEqual(this, by);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        this.base.traverseTopDown(visitor);
        this.root.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        this.base.traverseTopDown(visitor);
        this.root.traverseTopDown(visitor);
        visitor.visit(this);
    }

    @Override
    public boolean isGreaterOrEqual(ComparableNumeric numeric) {
        return this.compareTo(numeric) >= 0;
    }

    @Override
    public boolean isGreaterThan(ComparableNumeric numeric) {
        return this.compareTo(numeric) > 0;
    }

    @Override
    public boolean isLessOrEqual(ComparableNumeric numeric) {
        return this.compareTo(numeric) <= 0;
    }

    @Override
    public boolean isLessThan(ComparableNumeric numeric) {
        return this.compareTo(numeric) < 0;
    }

    public RootNumber roundToGrid(RootNumber gridsize) {
        return null;
    }

    public RootNumber max(RootNumber other) {
        return this.isGreaterOrEqual(other) ? this : other;
    }

    public RootNumber min(RootNumber other) {
        return this.isLessOrEqual(other) ? this : other;
    }

    public Double asDouble() {
        BigDecimal bd = ((IntegerFraction)this.getBase().getDenominator()).asBigDecimal();
        BigDecimal be = ((IntegerFraction)this.getRoot().getDenominator()).asBigDecimal();
        double dd = bd.doubleValue();
        double de = be.doubleValue();
        return Math.pow(dd, 1.0 / de);
    }

    public RootNumber atan() {
        return IntegerFraction.createFraction(Math.atan(this.asDouble()));
    }

    public RootNumber tan() {
        return IntegerFraction.createFraction(Math.tan(this.asDouble()));
    }

    public RootNumber log() {
        return IntegerFraction.createFraction(Math.log(this.asDouble()));
    }

    public RootNumber cos() {
        return IntegerFraction.createFraction(Math.cos(this.asDouble()));
    }

    public RootNumber acos() {
        return IntegerFraction.createFraction(Math.acos(this.asDouble()));
    }

    public RootNumber sin() {
        return IntegerFraction.createFraction(Math.sin(this.asDouble()));
    }

    public RootNumber asin() {
        return IntegerFraction.createFraction(Math.asin(this.asDouble()));
    }

    public RootNumber atan2(RootNumber xDelta) {
        return IntegerFraction.createFraction(Math.atan2(this.asDouble(), xDelta.asDouble()));
    }
}

