/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.ktde.math.helper.PartedNumberComparator;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.PartedNumber;
import org.ktde.math.number.SymbolNumber;

public class PartedNumberSum
extends PartedFraction {
    protected Vector<PartedNumber> parts;

    protected PartedNumberSum(String tostring) {
        super(tostring);
    }

    private PartedNumberSum(Vector<PartedNumber> parts) {
        super(PartedNumberSum.calcToString(parts));
        this.parts = parts;
    }

    private static String calcToString(Vector<PartedNumber> parts) {
        String res = "";
        boolean first = true;
        for (PartedNumber part : parts) {
            if (part.isNegative() || first) {
                res = res + part.toString();
                first = false;
                continue;
            }
            res = res + "+" + part.toString();
        }
        return res;
    }

    public static PartedFraction createPartedNumberSum(Vector<PartedNumber> parts) {
        PartedFraction result = null;
        if (parts.size() == 0) {
            result = IntegerNumber.ZERO;
        } else if (parts.size() == 1) {
            result = parts.firstElement();
        } else {
            IntegerFraction freeInt = IntegerNumber.ZERO;
            Collections.sort(parts, new PartedNumberComparator());
            PartedNumber lastNumber = null;
            int lastindex = -1;
            String lastid = null;
            Stack<String> lastidStack = new Stack<String>();
            lastidStack.push(lastid);
            Vector<PartedNumber> cpart = new Vector<PartedNumber>(parts.size());
            for (PartedNumber part : parts) {
                if (part instanceof IntegerFraction) {
                    freeInt = (IntegerFraction)((IntegerFraction)freeInt).add(part);
                    continue;
                }
                IntegerFraction factor = part.getFactor();
                String partString = part.divide(factor).toString();
                if (!partString.equals(lastid)) {
                    lastNumber = part;
                    cpart.addElement(lastNumber);
                    ++lastindex;
                    lastid = partString;
                    lastidStack.push(lastid);
                    continue;
                }
                if ((lastNumber = (PartedNumber)lastNumber.add(part)).equals(IntegerNumber.ZERO)) {
                    cpart.removeElementAt(lastindex);
                    lastid = (String)lastidStack.pop();
                    lastNumber = --lastindex >= 0 ? cpart.lastElement() : null;
                    continue;
                }
                cpart.setElementAt(lastNumber, lastindex);
            }
            if (!((IntegerFraction)freeInt).equals(IntegerNumber.ZERO)) {
                cpart.addElement(freeInt);
            }
            result = cpart.size() == 0 ? IntegerNumber.ZERO : (cpart.size() == 1 ? (PartedFraction)cpart.firstElement() : new PartedNumberSum(cpart));
        }
        return result;
    }

    public Vector<PartedNumber> getSumParts() {
        return this.parts;
    }

    @Override
    public IntegerNumber getDenominator() {
        return IntegerNumber.ONE;
    }

    @Override
    public PartedNumberSum getNumerator() {
        return this;
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedNumber) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size() + 1);
            parts.addAll(this.parts);
            parts.addElement((PartedNumber)numeric);
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else if (numeric instanceof PartedNumberSum) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size() + ((PartedNumberSum)numeric).parts.size());
            parts.addAll(this.parts);
            parts.addAll(((PartedNumberSum)numeric).parts);
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else {
            result = numeric.add(this);
        }
        return result;
    }

    @Override
    public Numeric sub(Numeric numeric) {
        return this.add(numeric.negate());
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedNumber) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size());
            for (PartedNumber part : this.parts) {
                part = (PartedNumber)part.multiply(numeric);
                parts.add(part);
            }
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else if (numeric instanceof PartedNumberSum) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size());
            for (PartedNumber part1 : this.parts) {
                for (PartedNumber part2 : parts) {
                    PartedNumber part = (PartedNumber)part1.multiply(part2);
                    parts.add(part);
                }
            }
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedNumber) {
            result = IntegerNumber.ZERO;
            for (Numeric numeric2 : this.getSumParts()) {
                Numeric numeric3 = numeric2.divide(numeric);
                result = result.add(numeric3);
            }
        } else if (numeric instanceof PartedNumberSum) {
            PartedNumberSum n = this;
            PartedNumber partedNumber = ((PartedNumberSum)numeric).getSumParts().firstElement();
            result = IntegerNumber.ZERO;
            while (!n.equals(IntegerNumber.ZERO)) {
                PartedNumber first = n.getSumParts().firstElement();
                PartedFraction div = (PartedFraction)first.divide(partedNumber);
                if (div instanceof PartedNumber) {
                    result = result.add(div);
                    n = (PartedNumberSum)n.sub(div.multiply(numeric));
                    continue;
                }
                result = PartedFraction.createFraction(this, (PartedNumberSum)numeric);
                break;
            }
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        Numeric result;
        if (numeric instanceof SymbolNumber) {
            Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size());
            for (PartedNumber part : this.parts) {
                part = (PartedNumber)part.modulo(numeric);
                parts.add(part);
            }
            result = PartedNumberSum.createPartedNumberSum(parts);
        } else if (numeric instanceof PartedNumberSum) {
            PartedNumberSum n = this;
            PartedNumber dfirst = ((PartedNumberSum)numeric).getSumParts().firstElement();
            result = IntegerNumber.ZERO;
            while (!n.equals(IntegerNumber.ZERO)) {
                PartedNumber first = n.getSumParts().firstElement();
                PartedFraction div = (PartedFraction)first.divide(dfirst);
                if (div instanceof PartedNumber) {
                    n = (PartedNumberSum)n.sub(div.multiply(numeric));
                    continue;
                }
                PartedNumber mod = (PartedNumber)first.modulo(dfirst);
                result = result.add(mod);
                n = (PartedNumberSum)n.sub(mod);
            }
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public PartedNumberSum negate() {
        Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size());
        for (PartedNumber part : this.parts) {
            part = part.negate();
            parts.add(part);
        }
        return (PartedNumberSum)PartedNumberSum.createPartedNumberSum(parts);
    }

    @Override
    public PartedFraction reciprocal() {
        return PartedFraction.createFraction(IntegerNumber.ONE, this);
    }

    @Override
    public Numeric ggT(Numeric numeric) {
        Numeric result;
        if (this.equals(IntegerNumber.ZERO) || numeric.equals(IntegerNumber.ZERO) || this.equals(IntegerNumber.ONE) || numeric.equals(IntegerNumber.ONE)) {
            result = IntegerNumber.ONE;
        } else if (numeric instanceof PartedNumber) {
            PartedNumber part;
            result = numeric;
            Iterator<PartedNumber> iterator = this.parts.iterator();
            while (iterator.hasNext() && !(result = result.ggT(part = iterator.next())).equals(IntegerNumber.ONE)) {
            }
        } else if (numeric instanceof PartedNumberSum) {
            if (this.isNegative() || ((PartedNumberSum)numeric).isNegative()) {
                result = this.abs().ggT(numeric.abs());
            } else {
                Numeric mod = this.modulo(numeric);
                System.out.println(this + " % " + numeric + "=" + mod);
                if (mod.equals(IntegerNumber.ZERO)) {
                    result = numeric;
                } else {
                    System.out.println(numeric + " - " + mod);
                    result = numeric.ggT(mod);
                }
            }
        } else {
            result = numeric.ggT(this);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        boolean result = false;
        if (o.getClass() == PartedNumberSum.class) {
            boolean bl = result = this.getSumParts().size() == ((PartedNumberSum)o).getSumParts().size();
            if (result) {
                for (int i = 0; i < this.getSumParts().size(); ++i) {
                    if (this.getSumParts().elementAt(i).equals(((PartedNumberSum)o).getSumParts().elementAt(i))) continue;
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public int compareTo(Numeric o) {
        int comp = 0;
        return comp;
    }

    @Override
    public boolean isNegative() {
        return this.parts.firstElement().isNegative();
    }

    @Override
    public boolean isPositive() {
        return this.parts.firstElement().isPositive();
    }

    @Override
    public PartedNumberSum abs() {
        Vector<PartedNumber> parts = new Vector<PartedNumber>(this.parts.size());
        for (PartedNumber part : this.parts) {
            part = part.abs();
            parts.add(part);
        }
        return (PartedNumberSum)PartedNumberSum.createPartedNumberSum(parts);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        for (PartedNumber part : this.parts) {
            part.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        for (PartedNumber part : this.parts) {
            part.traverseBottomUp(visitor);
        }
        visitor.visit(this);
    }
}

