/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.util.Vector;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.SymbolNumber;

public class NumericParser {
    public static Numeric parse(String s) {
        int[] pos = new int[]{0};
        Numeric result = NumericParser.parseBracket("(" + s + ")", pos);
        if (pos[0] != s.length() + 2) {
            throw new IllegalArgumentException(s.length() + 2 - pos[0] + " chars unparsed");
        }
        return result;
    }

    public static Numeric parseBracket(String s, int[] pos) {
        String[] order;
        char c;
        if (s.startsWith("-")) {
            s = "0" + s;
        }
        if ((c = s.charAt(pos[0])) != '(') {
            throw new IllegalArgumentException("Bracket must start with (");
        }
        pos[0] = pos[0] + 1;
        Vector<Numeric> parts = new Vector<Numeric>();
        Vector<Character> ops = new Vector<Character>();
        boolean nextNegative = false;
        while (c != ')') {
            c = s.charAt(pos[0]);
            if (c >= '0' && c <= '9') {
                parts.addElement(NumericParser.parseNumber(s, pos));
                nextNegative = false;
            } else if (c >= 'a' && c <= 'z') {
                parts.addElement(NumericParser.parseSingleSymbol(s, pos));
                nextNegative = false;
            } else if (c == '\"') {
                parts.addElement(NumericParser.parseQuotedSymbol(s, pos));
                nextNegative = false;
            } else if (c == '(') {
                parts.addElement(NumericParser.parseBracket(s, pos));
            } else {
                switch (c) {
                    case '#': 
                    case '%': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '^': {
                        ops.addElement(Character.valueOf(c));
                        break;
                    }
                    case ')': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown character " + c);
                    }
                }
                pos[0] = pos[0] + 1;
                if (parts.size() < ops.size()) {
                    if (!nextNegative && c == '-') {
                        nextNegative = true;
                        ops.setElementAt(Character.valueOf('*'), ops.size() - 1);
                        parts.addElement(IntegerNumber.MINUSONE);
                    } else {
                        throw new IllegalArgumentException("more than one operator");
                    }
                }
            }
            if (parts.size() != ops.size() + 2) continue;
            ops.addElement(Character.valueOf('*'));
        }
        if (ops.size() >= parts.size() || nextNegative) {
            throw new IllegalArgumentException("unclosed operator");
        }
        for (String lops : order = new String[]{"^#", "*/%", "+-"}) {
            int j;
            for (j = 0; j < ops.size(); ++j) {
            }
            for (j = 0; j < ops.size(); ++j) {
                if (lops.indexOf(((Character)ops.elementAt(j)).charValue()) < 0) continue;
                switch (((Character)ops.elementAt(j)).charValue()) {
                    case '+': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).add((Numeric)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '-': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).sub((Numeric)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '*': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).multiply((Numeric)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '/': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).divide((Numeric)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '%': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).modulo((Numeric)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '^': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).pow((IntegerFraction)parts.elementAt(j + 1)), j);
                        break;
                    }
                    case '#': {
                        parts.setElementAt(((Numeric)parts.elementAt(j)).pow((IntegerFraction)((Numeric)parts.elementAt(j + 1)).negate()), j);
                    }
                }
                ops.removeElementAt(j);
                parts.removeElementAt(j + 1);
                --j;
            }
        }
        if (parts.size() != 1) {
            throw new IllegalArgumentException("term evaluation didnt work");
        }
        return (Numeric)parts.firstElement();
    }

    private static Numeric parseSingleSymbol(String s, int[] pos) {
        SymbolNumber n;
        char c = s.charAt(pos[0]);
        pos[0] = pos[0] + 1;
        if (s.charAt(pos[0]) == '[') {
            pos[0] = pos[0] + 1;
            String index = NumericParser.parseIntegerAsString(s, pos);
            if (index.length() == 0 || s.charAt(pos[0]) != ']') {
                throw new IllegalArgumentException("coeffient must only contain integer");
            }
            pos[0] = pos[0] + 1;
            n = new SymbolNumber(c + "[" + index + "]");
        } else {
            n = new SymbolNumber(c);
        }
        return n;
    }

    private static Numeric parseQuotedSymbol(String s, int[] pos) {
        SymbolNumber n;
        String qc = NumericParser.parseQuotedString(s, pos);
        if (s.charAt(pos[0]) == '[') {
            pos[0] = pos[0] + 1;
            String index = NumericParser.parseIntegerAsString(s, pos);
            if (index.length() == 0 || s.charAt(pos[0]) != ']') {
                throw new IllegalArgumentException("coeffient must only contain integer");
            }
            pos[0] = pos[0] + 1;
            n = new SymbolNumber(qc + "[" + index + "]");
        } else {
            n = new SymbolNumber(qc);
        }
        return n;
    }

    private static String parseIntegerAsString(String s, int[] pos) {
        char c = s.charAt(pos[0]);
        int p1 = pos[0];
        while (c >= '0' && c <= '9') {
            pos[0] = pos[0] + 1;
            c = s.charAt(pos[0]);
        }
        return s.substring(p1, pos[0]);
    }

    private static String parseQuotedString(String s, int[] pos) {
        char c = s.charAt(pos[0]);
        if (c != '\"') {
            throw new IllegalArgumentException("quoted string must start with quote");
        }
        pos[0] = pos[0] + 1;
        int p1 = pos[0];
        while (c != '\"') {
            pos[0] = pos[0] + 1;
            c = s.charAt(pos[0]);
        }
        return s.substring(p1, pos[0] - 1);
    }

    private static IntegerNumber parseNumber(String s, int[] pos) {
        return IntegerNumber.createIntegerNumber(NumericParser.parseIntegerAsString(s, pos));
    }
}

