/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Vector;
import org.ktde.math.number.ComparableNumeric;
import org.ktde.math.number.ComplexNumber;
import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.RootNumber;

public class IntegerNumber
extends IntegerFraction {
    public static final IntegerNumber MINUSONE = new IntegerNumber(BigInteger.ONE.negate());
    public static final IntegerNumber ONE = new IntegerNumber(BigInteger.ONE);
    public static final IntegerNumber TWO = new IntegerNumber(BigInteger.ONE.add(BigInteger.ONE));
    public static final IntegerNumber ZERO = new IntegerNumber(BigInteger.ZERO);
    private BigInteger intValue;
    private Vector<IntegerNumber> primfactors;

    private IntegerNumber(BigInteger b) {
        super(b.toString());
        this.intValue = b;
    }

    public static IntegerNumber createIntegerNumber(String s) {
        return new IntegerNumber(new BigInteger(s));
    }

    public static IntegerNumber createIntegerNumber(int i) {
        return new IntegerNumber(BigInteger.valueOf(i));
    }

    public static IntegerNumber createIntegerNumber(Integer i) {
        return new IntegerNumber(BigInteger.valueOf(i.intValue()));
    }

    public static IntegerNumber createIntegerNumber(long l) {
        return new IntegerNumber(BigInteger.valueOf(l));
    }

    public static IntegerNumber createIntegerNumber(BigInteger b) {
        return new IntegerNumber(b);
    }

    @Override
    public IntegerNumber abs() {
        if (this.isNegative()) {
            return this.negate();
        }
        return this;
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result = numeric instanceof IntegerNumber ? new IntegerNumber(this.intValue.add(((IntegerNumber)numeric).intValue)) : numeric.add(this);
        return result;
    }

    @Override
    public int compareTo(ComparableNumeric o) {
        int comp = 0;
        if (o instanceof IntegerNumber) {
            comp = this.intValue.compareTo(((IntegerNumber)o).intValue);
        } else if (o instanceof ComparableNumeric) {
            comp = -o.compareTo(this);
        }
        return comp;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (this.equals(ZERO)) {
            result = this;
        } else if (numeric instanceof IntegerNumber) {
            IntegerNumber numeric2 = (IntegerNumber)numeric.abs();
            result = this.intValue.abs().mod(numeric2.intValue).equals(BigInteger.ZERO) ? new IntegerNumber(this.intValue.divide(((IntegerNumber)numeric).intValue)) : IntegerFraction.createFraction(this, (IntegerNumber)numeric);
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public Numeric ggT(Numeric n) {
        Numeric mod;
        Numeric result = this.equals(ZERO) || n.equals(ZERO) || this.equals(ONE) || n.equals(ONE) ? ONE : (n instanceof IntegerNumber ? (this.isNegative() || ((IntegerNumber)n).isNegative() ? this.abs().ggT(n.abs()) : ((mod = this.modulo(n)).equals(ZERO) ? n : n.ggT(mod))) : n.ggT(this));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == IntegerNumber.class && ((IntegerNumber)o).intValue.equals(this.intValue);
    }

    @Override
    public IntegerNumber getDenominator() {
        return ONE;
    }

    @Override
    public IntegerNumber getNumerator() {
        return this;
    }

    public boolean isEven() {
        return this.abs().modulo(TWO).equals(ZERO);
    }

    @Override
    public boolean isNegative() {
        return this.intValue.compareTo(BigInteger.ZERO) < 0;
    }

    public boolean isOdd() {
        return this.abs().modulo(TWO).equals(ONE);
    }

    @Override
    public boolean isPositive() {
        return this.intValue.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        Numeric result;
        if (numeric instanceof IntegerNumber) {
            result = new IntegerNumber(this.intValue.mod(((IntegerNumber)numeric).intValue));
        } else if (numeric instanceof IntegerFraction) {
            IntegerNumber numerator = (IntegerNumber)this.multiply(((IntegerFraction)numeric).getDenominator()).modulo(((IntegerFraction)numeric).getNumerator());
            IntegerNumber denominator = ((IntegerFraction)numeric).getDenominator();
            result = numerator.divide(denominator);
        } else {
            result = this;
        }
        return result;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result = this.equals(ZERO) ? this : (numeric instanceof IntegerNumber ? new IntegerNumber(this.intValue.multiply(((IntegerNumber)numeric).intValue)) : numeric.multiply(this));
        return result;
    }

    @Override
    public IntegerNumber negate() {
        return new IntegerNumber(this.intValue.negate());
    }

    public boolean isProbablePrime() {
        boolean result = this.intValue.isProbablePrime(10);
        return result;
    }

    public Vector<IntegerNumber> getPrimFactors(boolean addsign) {
        if (this.primfactors == null) {
            this.primfactors = new Vector();
            if (this.isNegative()) {
                if (addsign) {
                    this.primfactors.addElement(MINUSONE);
                }
                this.primfactors.addAll(this.negate().getPrimFactors(false));
            } else if (this.equals(ONE)) {
                this.primfactors.addElement(this);
            } else if (this.isProbablePrime()) {
                this.primfactors.addElement(this);
            } else {
                IntegerNumber x = this;
                while (!x.equals(TWO)) {
                    IntegerNumber d = (IntegerNumber)this.ggT(x = (IntegerNumber)x.sub(ONE));
                    if (d.equals(ONE)) continue;
                    IntegerNumber p1 = (IntegerNumber)this.divide(d);
                    this.primfactors.addAll(p1.getPrimFactors(false));
                    this.primfactors.addAll(d.getPrimFactors(false));
                    break;
                }
                Collections.sort(this.primfactors);
            }
        }
        return this.primfactors;
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        ComplexNumber result;
        if (exponent.compareTo(ZERO) == 0) {
            result = ONE;
        } else if (exponent.compareTo(ONE) == 0) {
            result = this;
        } else if (exponent.isNegative()) {
            result = this.pow(exponent.negate()).reciprocal();
        } else if (exponent instanceof IntegerNumber) {
            result = new IntegerNumber(this.intValue.pow(((IntegerNumber)exponent).intValue.intValue()));
        } else {
            result = null;
            IntegerNumber numerator = exponent.getNumerator();
            IntegerNumber denomiator = exponent.getDenominator();
            if (!numerator.equals(ONE)) {
                result = this.pow(numerator).pow(denomiator.reciprocal());
            } else {
                boolean good = false;
                if ((long)denomiator.intValue.intValue() == denomiator.intValue.longValue()) {
                    Vector<IntegerNumber> factors = this.getPrimFactors(false);
                    int test = denomiator.intValue.intValue();
                    if (factors.size() % test == 0) {
                        int i;
                        good = true;
                        for (i = 0; i < factors.size(); i += test) {
                            IntegerNumber t = factors.elementAt(i);
                            for (int j = 1; j < test; ++j) {
                                if (t.equals(factors.elementAt(i + j))) continue;
                                good = false;
                                break;
                            }
                            if (!good) break;
                        }
                        if (good) {
                            result = ONE;
                            for (i = 0; i < factors.size(); i += test) {
                                result = (ComplexNumber)result.multiply(factors.elementAt(i));
                            }
                            if (this.isNegative()) {
                                if (denomiator.equals(TWO)) {
                                    result = ComplexNumber.createComplexNumber(ZERO, (PartedFraction)result);
                                } else if (!denomiator.isEven()) {
                                    result = result.negate();
                                }
                            }
                        }
                    }
                }
                if (!good) {
                    result = RootNumber.createRootNumber(this, denomiator);
                }
            }
        }
        return result;
    }

    @Override
    public IntegerFraction reciprocal() {
        return IntegerFraction.createFraction(ONE, this);
    }

    @Override
    public Numeric sub(Numeric numeric) {
        Numeric result = numeric instanceof IntegerNumber ? new IntegerNumber(this.intValue.subtract(((IntegerNumber)numeric).intValue)) : numeric.sub(this).negate();
        return result;
    }

    public BigInteger getValue() {
        return this.intValue;
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BigDecimal asBigDecimal() {
        return new BigDecimal(this.intValue);
    }
}

