/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.number;

import org.ktde.math.number.IntegerFraction;
import org.ktde.math.number.IntegerNumber;
import org.ktde.math.number.Numeric;
import org.ktde.math.number.NumericVisitor;
import org.ktde.math.number.PartedFraction;
import org.ktde.math.number.PartedNumber;
import org.ktde.math.number.PartedNumberSum;
import org.ktde.math.number.RootNumber;
import org.ktde.math.number.SymbolNumber;

public class ComplexNumber
implements Numeric {
    public static final ComplexNumber ONE_IM = new ComplexNumber(IntegerNumber.ZERO, IntegerNumber.ONE, false);
    private String tostring;
    private PartedFraction real;
    private PartedFraction imaginary;

    protected ComplexNumber(String tostring) {
        this.tostring = tostring;
    }

    private ComplexNumber(PartedFraction real, PartedFraction imaginary, boolean calc) {
        this(calc ? "" : ComplexNumber.calcToString(real, imaginary));
        this.real = real;
        this.imaginary = imaginary;
    }

    private ComplexNumber(PartedFraction real, PartedFraction imaginary) {
        this(real, imaginary, true);
    }

    private static String calcToString(PartedFraction real, PartedFraction imaginary) {
        String rs = "";
        String img = "";
        if (real != null) {
            if (!real.equals(IntegerNumber.ZERO)) {
                rs = real.toString();
                if (imaginary.isPositive()) {
                    rs = rs + "+";
                }
            }
            img = imaginary.toString();
            img = imaginary.equals(IntegerNumber.ONE) ? "i" : (imaginary.equals(IntegerNumber.MINUSONE) ? "-i" : (imaginary.isNegative() ? "-i" + img.substring(1) : "i" + img));
        }
        return rs + img;
    }

    public static ComplexNumber createComplexNumber(PartedFraction real, PartedFraction imaginary) {
        if (imaginary.equals(IntegerNumber.ZERO)) {
            return real;
        }
        return new ComplexNumber(real, imaginary);
    }

    @Override
    public Numeric add(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.add(numeric), this.imaginary);
        } else if (numeric instanceof ComplexNumber) {
            ComplexNumber cNumber = (ComplexNumber)numeric;
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.add(cNumber.real), (PartedFraction)this.imaginary.add(cNumber.imaginary));
        } else {
            result = numeric.add(this);
        }
        return result;
    }

    @Override
    public Numeric divide(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.divide(numeric), (PartedFraction)this.imaginary.divide(numeric));
        } else if (numeric instanceof ComplexNumber) {
            ComplexNumber cNumber = (ComplexNumber)numeric;
            PartedFraction a = this.real;
            PartedFraction b = this.imaginary;
            PartedFraction c = cNumber.real;
            PartedFraction d = cNumber.imaginary;
            PartedFraction denominator = (PartedFraction)c.multiply(c).add(d.multiply(d));
            PartedFraction real = (PartedFraction)a.multiply(c).add(b.multiply(d)).divide(denominator);
            PartedFraction imaginary = (PartedFraction)b.multiply(c).sub(a.multiply(d)).divide(denominator);
            result = ComplexNumber.createComplexNumber(real, imaginary);
        } else {
            result = numeric.divide(this).reciprocal();
        }
        return result;
    }

    @Override
    public Numeric modulo(Numeric numeric) {
        return null;
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.multiply(numeric), (PartedFraction)this.imaginary.multiply(numeric));
        } else if (numeric instanceof ComplexNumber) {
            ComplexNumber cNumber = (ComplexNumber)numeric;
            PartedFraction a = this.real;
            PartedFraction b = this.imaginary;
            PartedFraction c = cNumber.real;
            PartedFraction d = cNumber.imaginary;
            PartedFraction real = (PartedFraction)a.multiply(c).sub(b.multiply(d));
            PartedFraction imaginary = (PartedFraction)a.multiply(d).add(b.multiply(c));
            result = ComplexNumber.createComplexNumber(real, imaginary);
        } else {
            result = numeric.multiply(this);
        }
        return result;
    }

    @Override
    public ComplexNumber negate() {
        return ComplexNumber.createComplexNumber(this.real.negate(), this.imaginary.negate());
    }

    @Override
    public ComplexNumber reciprocal() {
        PartedFraction denominator = (PartedFraction)this.real.multiply(this.real).add(this.imaginary.multiply(this.imaginary));
        PartedFraction real = (PartedFraction)this.real.divide(denominator);
        PartedFraction imaginary = (PartedFraction)this.imaginary.divide(denominator).negate();
        return ComplexNumber.createComplexNumber(real, imaginary);
    }

    @Override
    public Numeric sub(Numeric numeric) {
        Numeric result;
        if (numeric instanceof PartedFraction) {
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.sub(numeric), this.imaginary);
        } else if (numeric instanceof ComplexNumber) {
            ComplexNumber cNumber = (ComplexNumber)numeric;
            result = ComplexNumber.createComplexNumber((PartedFraction)this.real.sub(cNumber.real), (PartedFraction)this.imaginary.sub(cNumber.imaginary));
        } else {
            result = numeric.sub(this).negate();
        }
        return result;
    }

    public final String toString() {
        return this.tostring;
    }

    @Override
    public ComplexNumber abs() {
        return ComplexNumber.createComplexNumber(this.real.abs(), this.imaginary.abs());
    }

    public PartedFraction getReal() {
        return this.real;
    }

    public PartedFraction getImaginary() {
        return this.imaginary;
    }

    public boolean equals(Object o) {
        return o.getClass() == ComplexNumber.class && ((ComplexNumber)o).real.equals(this.real) && ((ComplexNumber)o).imaginary.equals(this.imaginary);
    }

    @Override
    public ComplexNumber pow(IntegerFraction exponent) {
        ComplexNumber result;
        if (exponent.compareTo(IntegerNumber.ZERO) == 0) {
            result = IntegerNumber.ONE;
        } else if (exponent.compareTo(IntegerNumber.ONE) == 0) {
            result = this;
        } else if (exponent.compareTo(IntegerNumber.TWO) == 0) {
            result = (ComplexNumber)this.multiply(this);
        } else if (exponent.isNegative()) {
            result = this.pow(exponent.negate()).reciprocal();
        } else if (exponent instanceof IntegerNumber) {
            if (((IntegerNumber)exponent).isOdd()) {
                exponent = (IntegerNumber)exponent.sub(IntegerNumber.ONE);
                result = this;
            } else {
                result = IntegerNumber.ONE;
            }
            exponent = (IntegerNumber)exponent.divide(IntegerNumber.TWO);
            result = (ComplexNumber)result.multiply(this.pow(exponent)).multiply(this.pow(exponent));
        } else {
            result = RootNumber.createRootNumber(this, exponent.reciprocal());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Numeric solveEqual(Numeric numeric, SymbolNumber by) {
        int comp;
        IntegerNumber exp;
        if (numeric.getClass() == RootNumber.class) {
            return this.pow(((RootNumber)numeric).getRoot()).solveEqual(((RootNumber)numeric).getBase(), by);
        }
        if (!(numeric instanceof ComplexNumber)) return numeric.solveEqual(this, by);
        System.out.println(this + "=" + numeric);
        PartedNumberSum commondenom = (PartedNumberSum)this.getReal().getDenominator().multiply(this.getImaginary().getDenominator().multiply(((ComplexNumber)numeric).getReal().getDenominator().multiply(((ComplexNumber)numeric).getImaginary().getDenominator())));
        PartedNumberSum leftreal = (PartedNumberSum)this.getReal().multiply(commondenom);
        PartedNumberSum leftimaginary = (PartedNumberSum)this.getImaginary().multiply(commondenom);
        PartedNumberSum rightreal = (PartedNumberSum)((ComplexNumber)numeric).getReal().multiply(commondenom);
        PartedNumberSum rightimaginary = (PartedNumberSum)((ComplexNumber)numeric).getImaginary().multiply(commondenom);
        IntegerNumber maxexp = IntegerNumber.ZERO;
        IntegerNumber minexp = IntegerNumber.ZERO;
        for (PartedNumber element : leftreal.getSumParts()) {
            exp = element.getExponentOf(by);
            if (exp.equals(IntegerNumber.ZERO)) {
                rightreal = (PartedNumberSum)rightreal.sub(element);
                leftreal = (PartedNumberSum)leftreal.sub(element);
                continue;
            }
            comp = exp.compareTo(maxexp);
            if (comp > 0) {
                maxexp = exp;
            }
            comp = exp.compareTo(minexp);
            if (!minexp.equals(IntegerNumber.ZERO) && comp >= 0) continue;
            minexp = exp;
        }
        for (PartedNumber element : leftimaginary.getSumParts()) {
            exp = element.getExponentOf(by);
            if (exp.equals(IntegerNumber.ZERO)) {
                rightimaginary = (PartedNumberSum)rightimaginary.sub(element);
                leftimaginary = (PartedNumberSum)leftimaginary.sub(element);
                continue;
            }
            comp = exp.compareTo(maxexp);
            if (comp > 0) {
                maxexp = exp;
            }
            comp = exp.compareTo(minexp);
            if (!minexp.equals(IntegerNumber.ZERO) && comp >= 0) continue;
            minexp = exp;
        }
        for (PartedNumber element : rightreal.getSumParts()) {
            exp = element.getExponentOf(by);
            if (exp.equals(IntegerNumber.ZERO)) {
                leftreal = (PartedNumberSum)leftreal.sub(element);
                rightreal = (PartedNumberSum)rightreal.sub(element);
                continue;
            }
            comp = exp.compareTo(maxexp);
            if (comp > 0) {
                maxexp = exp;
            }
            comp = exp.compareTo(minexp);
            if (!minexp.equals(IntegerNumber.ZERO) && comp >= 0) continue;
            minexp = exp;
        }
        for (PartedNumber element : rightimaginary.getSumParts()) {
            exp = element.getExponentOf(by);
            if (exp.equals(IntegerNumber.ZERO)) {
                leftimaginary = (PartedNumberSum)leftimaginary.sub(element);
                rightimaginary = (PartedNumberSum)rightimaginary.sub(element);
                continue;
            }
            comp = exp.compareTo(maxexp);
            if (comp > 0) {
                maxexp = exp;
            }
            comp = exp.compareTo(minexp);
            if (!minexp.equals(IntegerNumber.ZERO) && comp >= 0) continue;
            minexp = exp;
        }
        if (maxexp.equals(IntegerNumber.ZERO)) {
            if (!(rightreal instanceof IntegerFraction)) return by;
            if (!(rightimaginary instanceof IntegerFraction)) return by;
            if (!rightreal.equals(IntegerNumber.ZERO)) throw new IllegalArgumentException("cannot solve " + this + "=" + numeric);
            if (!rightimaginary.equals(IntegerNumber.ZERO)) throw new IllegalArgumentException("cannot solve " + this + "=" + numeric);
            return by;
        }
        if (maxexp.equals(minexp)) {
            return ComplexNumber.createComplexNumber(rightreal, rightimaginary).divide(ComplexNumber.createComplexNumber(leftreal, leftimaginary).divide(by.pow(minexp))).pow(minexp.reciprocal());
        }
        if (!rightreal.equals(IntegerNumber.ZERO)) throw new RuntimeException("solve polynomal not yet implemented");
        if (!rightimaginary.equals(IntegerNumber.ZERO)) throw new RuntimeException("solve polynomal not yet implemented");
        return ComplexNumber.createComplexNumber(leftreal, leftimaginary).divide(by.pow(minexp)).solveEqual(IntegerNumber.ZERO, by);
    }

    @Override
    public void traverseTopDown(NumericVisitor visitor) {
        visitor.visit(this);
        this.real.traverseTopDown(visitor);
        this.imaginary.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(NumericVisitor visitor) {
        this.real.traverseTopDown(visitor);
        this.imaginary.traverseTopDown(visitor);
        visitor.visit(this);
    }

    @Override
    public Numeric ggT(Numeric numeric) {
        return null;
    }

    public ComplexNumber getConjugate() {
        return ComplexNumber.createComplexNumber(this.real, this.imaginary.negate());
    }

    static {
        ComplexNumber.ONE_IM.tostring = "i";
    }
}

