/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.helper;

import java.util.List;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

public class ComputeTrigonometrics {
    public static double normalizeAngle(double angle, boolean boundZero) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle == 0.0 && !boundZero) {
            angle = Math.PI * 2;
        }
        return angle;
    }

    public static double normalizeAngle(double angle) {
        return ComputeTrigonometrics.normalizeAngle(angle, true);
    }

    public static double normalizeAngle(double x, double y, double x0, double y0) {
        return ComputeTrigonometrics.normalizeAngle(Math.atan2(y0 - y, x0 - x), true);
    }

    public static double angleBetween(double x, double y, double x0, double y0, double x1, double y1) {
        double phi0 = Math.atan2(y0 - y, x0 - x);
        double phi1 = Math.atan2(y1 - y, x1 - x);
        return ComputeTrigonometrics.normalizeAngle(phi1 - phi0);
    }

    private static double deg2rad(double angle) {
        return angle * Math.PI / 180.0;
    }

    private static double rad2deg(double angle) {
        return angle * 180.0 / Math.PI;
    }

    public static double getSphericalDistance(Coordinate from, Coordinate to) {
        double distance = 0.0;
        from = Wgs84Factory.INSTANCE.createCoordinate(from);
        to = Wgs84Factory.INSTANCE.createCoordinate(to);
        double fromB = from.getY();
        double fromL = from.getX();
        double latFrom = ComputeTrigonometrics.deg2rad(fromB);
        double lonFrom = ComputeTrigonometrics.deg2rad(fromL);
        double toB = to.getY();
        double toL = to.getX();
        double latTo = ComputeTrigonometrics.deg2rad(toB);
        double lonTo = ComputeTrigonometrics.deg2rad(toL);
        double dsB1 = Math.sin(latFrom);
        double dsB2 = Math.sin(latTo);
        double dcB1 = Math.cos(latFrom);
        double dcB2 = Math.cos(latTo);
        double dcL = Math.cos(lonTo - lonFrom);
        double metersPerDegree = 111.11999998974001;
        double dtmp = ComputeTrigonometrics.rad2deg(metersPerDegree * Math.acos(dsB1 * dsB2 + dcB1 * dcB2 * dcL));
        distance = dtmp * 1000.0;
        return distance;
    }

    public static Double getSphericalLength(List<Coordinate> coords) {
        Coordinate lastcoord = null;
        double length = 0.0;
        for (Coordinate coordinate : coords) {
            if (lastcoord != null) {
                length += ComputeTrigonometrics.getSphericalDistance(lastcoord, coordinate);
            }
            lastcoord = coordinate;
        }
        return length;
    }
}

