/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Hashtable;
import java.util.Iterator;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractMatching;
import org.ktde.util.datatypes.SimplePriorityQueue;

public class GreedyMatching
extends AbstractMatching {
    private int costIndexEdge;

    public GreedyMatching(Graph graph, int costIndexEdge) {
        super(graph);
        this.costIndexEdge = costIndexEdge;
    }

    @Override
    public void reset(Graph g) {
        super.reset(g);
        this.resultGraph.addNodes(this.graph);
    }

    @Override
    protected void perform() {
        Hashtable known = new Hashtable();
        SimplePriorityQueue queue = new SimplePriorityQueue();
        Iterator<Edge<?>> iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> e = iterator.next();
            queue.insertElement(e, e.getCostAt(this.costIndexEdge));
        }
        this.finishStep(this.graph.getEdgeCount(), 0);
        while (queue.hasNext()) {
            Edge e = (Edge)queue.next();
            Node<?> start = e.getStart();
            Node<?> target = e.getTarget();
            if (!known.containsKey(start) && !known.containsKey(target)) {
                this.resultGraph.addEdge(e);
                known.put(start, true);
                known.put(target, true);
            }
            this.finishStep();
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getEdgeCount() * 2;
    }
}

