/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractAllPairShortestPath;
import org.ktde.util.datatypes.Tupel;

public class FloydWarshallAllPairShortestPath
extends AbstractAllPairShortestPath {
    public FloydWarshallAllPairShortestPath(Graph graph, int costIndexEdge, int costIndexNode) {
        super(graph, costIndexEdge, costIndexNode);
    }

    public FloydWarshallAllPairShortestPath(Graph graph, int costIndexEdge) {
        super(graph, costIndexEdge, -1);
    }

    @Override
    protected void perform() {
        int count = this.graph.getNodeCount();
        Hashtable<Tupel<Object, Object>, Edge<Object>> predecessors = new Hashtable<Tupel<Object, Object>, Edge<Object>>(count * count);
        this.paths = new Hashtable(count * count);
        this.costs = new Hashtable(count * count);
        Tupel<Object, Object> tupelij = new Tupel<Object, Object>(null, null);
        Tupel<Object, Object> tupelik = new Tupel<Object, Object>(null, null);
        Tupel<Object, Object> tupelkj = new Tupel<Object, Object>(null, null);
        Iterator<Node<?>> iterator2 = this.graph.getNodeIterator();
        while (iterator2.hasNext()) {
            Node<?> i = iterator2.next();
            tupelij.setElement1(i);
            Iterator<Node<?>> iterator3 = this.graph.getNodeIterator();
            while (iterator3.hasNext()) {
                Node<?> j = iterator3.next();
                tupelij.setElement2(j);
                if (i == j) {
                    this.costs.put(tupelij, 0.0);
                    System.out.println("set cost " + i + " to " + j + " to 0 " + tupelij.hashCode());
                } else {
                    this.costs.put(tupelij, Double.MAX_VALUE);
                    System.out.println("set cost " + i + " to " + j + " to inf " + tupelij.hashCode());
                }
                this.paths.put(tupelij, new ArrayList());
            }
        }
        Iterator<Object> iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> e = iterator.next();
            tupelij.setElement1(e.getStart());
            tupelij.setElement2(e.getTarget());
            double cost = (Double)this.costs.get(tupelij);
            double d = this.costIndexEdge >= 0 ? e.getCostAt(this.costIndexEdge) : 0.0;
            double direct = d;
            if (!(cost > direct)) continue;
            this.costs.put(tupelij, direct);
            if (((List)this.paths.get(tupelij)).isEmpty()) {
                ((List)this.paths.get(tupelij)).add(e);
            } else {
                ((List)this.paths.get(tupelij)).set(0, e);
            }
            predecessors.put(tupelij, e);
            System.out.println("overwrite cost " + e.getStart() + " to " + e.getTarget() + " to " + direct + " " + tupelij.hashCode());
        }
        iterator = this.graph.getNodeIterator();
        while (iterator.hasNext()) {
            Node k = (Node)iterator.next();
            tupelik.setElement2(k);
            tupelkj.setElement1(k);
            double nodeTraverse = this.costIndexNode >= 0 ? k.getCostAt(this.costIndexNode) : 0.0;
            Iterator<Node<?>> iterator22 = this.graph.getNodeIterator();
            while (iterator22.hasNext()) {
                Node<?> i = iterator22.next();
                if (i == k) continue;
                tupelij.setElement1(i);
                tupelik.setElement1(i);
                Iterator<Node<?>> iterator3 = this.graph.getNodeIterator();
                while (iterator3.hasNext()) {
                    Node<?> j = iterator3.next();
                    if (j == k || i == j) continue;
                    tupelij.setElement2(j);
                    tupelkj.setElement2(j);
                    System.out.println("Check way " + i + " to " + j + " over " + k);
                    System.out.println("read " + tupelij + " " + tupelij.hashCode());
                    double costij = (Double)this.costs.get(tupelij);
                    System.out.println("read " + tupelik + " " + tupelik.hashCode());
                    double costik = (Double)this.costs.get(tupelik);
                    System.out.println("read " + tupelkj + " " + tupelkj.hashCode());
                    double costkj = (Double)this.costs.get(tupelkj);
                    System.out.println(costij + " vs " + costik + "+" + costkj);
                    double costikj = costik + nodeTraverse + costkj;
                    if (costikj < costij) {
                        this.costs.put(tupelij, costikj);
                        predecessors.put(tupelij, (Edge<Object>)predecessors.get(tupelkj));
                        List pathij = (List)this.paths.get(tupelij);
                        pathij.clear();
                        pathij.addAll((Collection)this.paths.get(tupelik));
                        pathij.addAll((Collection)this.paths.get(tupelkj));
                    }
                    this.finishStep();
                }
            }
        }
    }

    @Override
    public int preCalcSteps() {
        int count = this.graph.getNodeCount();
        return count * count * count + count * count;
    }
}

