/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractPathFinder;
import org.ktde.util.datatypes.SimplePriorityQueue;

public class DijkstraPathFinder
extends AbstractPathFinder {
    public DijkstraPathFinder(Graph graph, Node<?> start, Node<?> target, int costIndexEdge) {
        super(graph, start, target, costIndexEdge);
    }

    public DijkstraPathFinder(Graph graph, Node<?> start, Node<?> target, int costIndexEdge, int costIndexNode) {
        super(graph, start, target, costIndexEdge, costIndexNode);
    }

    @Override
    protected void perform() {
        List list;
        this.tour = new Vector();
        int toProcess = this.preCalcSteps();
        SimplePriorityQueue queue = new SimplePriorityQueue();
        Hashtable<Node, Node> persist = new Hashtable<Node, Node>();
        Hashtable tours = new Hashtable();
        queue.insertElement(this.start, 0.0);
        persist.put(this.start, this.start);
        boolean succees = false;
        while (queue.hasNext()) {
            Node node = (Node)queue.next();
            node.assertValueCount(2);
            node.setValueAt(0, 1);
            if (node.equals(this.target)) {
                succees = true;
                this.finishStep(toProcess, toProcess);
                break;
            }
            persist.put(node, node);
            double length = (Double)queue.getValue(node);
            int neighCount = this.graph.getOutEdgeCount(node);
            for (int i = 0; i < neighCount; ++i) {
                Edge<?> edge = this.graph.getOutEdgeAt(node, i);
                Node<?> other = edge.getOther(node);
                other.assertValueCount(2);
                List tourBefore = (List)tours.get(node);
                edge.assertCostCount(this.costIndexEdge + 1);
                other.assertCostCount(this.costIndexNode + 1);
                double cost = length + (this.costIndexEdge >= 0 ? edge.getCostAt(this.costIndexEdge) : 0.0) + (this.costIndexNode >= 0 ? other.getCostAt(this.costIndexNode) : 0.0);
                if (persist.containsKey(other)) continue;
                if (!tours.containsKey(other)) {
                    other.setValueAt(0, 2);
                    other.setValueAt(1, (int)cost);
                    queue.insertElement(other, cost);
                    ArrayList list2 = new ArrayList();
                    if (tourBefore != null) {
                        list2.addAll(tourBefore);
                    }
                    list2.add(edge);
                    tours.put(other, list2);
                    continue;
                }
                double before = (Double)queue.getValue(other);
                if (before > cost) {
                    other.setValueAt(0, 3);
                    other.setValueAt(1, (int)cost);
                    queue.changeElement(other, cost);
                    ((List)tours.get(other)).add(edge);
                    List list3 = (List)tours.get(other);
                    list3.clear();
                    if (tourBefore != null) {
                        list3.addAll(tourBefore);
                    }
                    list3.add(edge);
                    continue;
                }
                other.setValueAt(0, 7);
            }
            this.finishStep();
            node.setValueAt(0, 6);
        }
        if (succees && (list = (List)tours.get(this.target)) != null) {
            this.tour.addAll(list);
            Node<?> node = this.start;
            node.setValueAt(0, 5);
            for (Edge edge : this.tour) {
                node = edge.getOther(node);
                node.setValueAt(0, 5);
                this.finishStep();
            }
            this.finishStep();
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getNodeCount();
    }
}

