/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractPartialPairShortestPath;
import org.ktde.util.datatypes.SimplePriorityQueue;
import org.ktde.util.datatypes.Tupel;

public class DijkstraPairPathFinder
extends AbstractPartialPairShortestPath {
    public DijkstraPairPathFinder(Graph graph, Graph nodeSet, int costIndexEdge, int costIndexNode) {
        super(graph, nodeSet, costIndexEdge, costIndexNode);
    }

    public DijkstraPairPathFinder(Graph graph, Graph nodeSet, int costIndexEdge) {
        super(graph, nodeSet, costIndexEdge);
    }

    public DijkstraPairPathFinder(Graph graph, int costIndexEdge, int costIndexNode) {
        super(graph, costIndexEdge, costIndexNode);
    }

    public DijkstraPairPathFinder(Graph graph, int costIndexEdge) {
        super(graph, costIndexEdge);
    }

    @Override
    protected void perform() {
        int count = this.graph.getNodeCount();
        int countNodeSet = this.nodeSet.getNodeCount();
        this.paths = new Hashtable(count * count);
        this.costs = new Hashtable(count * count);
        Iterator<Node<?>> iterator = this.nodeSet.getNodeIterator();
        block0: while (iterator.hasNext()) {
            Node<?> start = iterator.next();
            SimplePriorityQueue queue = new SimplePriorityQueue();
            Hashtable<Node, Node> persist = new Hashtable<Node, Node>();
            Hashtable paths = new Hashtable();
            Hashtable counts = new Hashtable();
            queue.insertElement(start, 0.0);
            persist.put(start, start);
            counts.put(start, 0);
            int countsuc = 0;
            while (queue.hasNext()) {
                Node node = (Node)queue.next();
                node.setValueAt(0, 1);
                persist.put(node, node);
                double length = (Double)queue.getValue(node);
                int neighCount = this.graph.getOutEdgeCount(node);
                List pathBefore = (List)paths.get(node);
                if (node != start && this.nodeSet.existsNode(node)) {
                    Tupel tupelij = new Tupel(start, node);
                    this.paths.put(tupelij, pathBefore);
                    this.costs.put(tupelij, length);
                    this.finishStep();
                    if (++countsuc == countNodeSet) continue block0;
                }
                for (int i = 0; i < neighCount; ++i) {
                    Edge<?> edge = this.graph.getOutEdgeAt(node, i);
                    Node<?> other = edge.getOther(node);
                    edge.assertCostCount(this.costIndexEdge + 1);
                    other.assertCostCount(this.costIndexNode + 1);
                    double cost = length + (this.costIndexEdge >= 0 ? edge.getCostAt(this.costIndexEdge) : 0.0) + (this.costIndexNode >= 0 ? other.getCostAt(this.costIndexNode) : 0.0);
                    if (persist.containsKey(other)) continue;
                    if (!paths.containsKey(other)) {
                        System.err.println("init with " + cost);
                        other.setValueAt(0, 2);
                        other.setValueAt(1, (int)cost);
                        queue.insertElement(other, cost);
                        ArrayList list = new ArrayList();
                        if (pathBefore != null) {
                            list.addAll(pathBefore);
                        }
                        list.add(edge);
                        paths.put(other, list);
                        continue;
                    }
                    double before = (Double)queue.getValue(other);
                    if (before > cost) {
                        System.err.println("change from " + before + " to " + cost);
                        other.setValueAt(0, 3);
                        other.setValueAt(1, (int)cost);
                        queue.changeElement(other, cost);
                        ((List)paths.get(other)).add(edge);
                        List list = (List)paths.get(other);
                        list.clear();
                        if (pathBefore != null) {
                            list.addAll(pathBefore);
                        }
                        list.add(edge);
                        continue;
                    }
                    other.setValueAt(0, 7);
                }
                this.finishStep();
                node.setValueAt(0, 6);
            }
        }
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getNodeCount() + 1;
    }
}

