/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Hashtable;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractIsochroneFinder;
import org.ktde.util.datatypes.SimplePriorityQueue;

public class DijkstraIsochroneFinder
extends AbstractIsochroneFinder {
    public DijkstraIsochroneFinder(Graph graph, Node<?> start, Vector<Double> costBorder, int costIndexEdge, int costIndexNode) {
        super(graph, start, costBorder, costIndexEdge, costIndexNode);
    }

    public DijkstraIsochroneFinder(Graph graph, Node<?> start, Vector<Double> costBorder, int costIndexEdge) {
        super(graph, start, costBorder, costIndexEdge);
    }

    @Override
    protected void perform() {
        SimplePriorityQueue queue = new SimplePriorityQueue();
        Hashtable<Node, Node> persist = new Hashtable<Node, Node>();
        Hashtable predecessors = new Hashtable();
        Hashtable counts = new Hashtable();
        queue.insertElement(this.start, 0.0);
        persist.put(this.start, this.start);
        counts.put(this.start, 0);
        int curIndex = 0;
        double curIso = (Double)this.costBorder.get(curIndex);
        Vector result = new Vector(this.costBorder.size());
        for (int i = 0; i < this.costBorder.size(); ++i) {
            result.addElement(new Vector());
        }
        block1: while (queue.hasNext()) {
            Node node = (Node)queue.next();
            node.setValueAt(0, 1);
            persist.put(node, node);
            double length = (Double)queue.getValue(node);
            while (length > curIso) {
                if (++curIndex == this.costBorder.size()) break block1;
                curIso = (Double)this.costBorder.get(curIndex);
            }
            ((Vector)result.get(curIndex)).addElement(node);
            int count = (Integer)counts.get(node);
            int neighCount = this.graph.getOutEdgeCount(node);
            for (int i = 0; i < neighCount; ++i) {
                Edge<?> edge = this.graph.getOutEdgeAt(node, i);
                Node<?> other = edge.getOther(node);
                edge.assertCostCount(this.costIndexEdge + 1);
                other.assertCostCount(this.costIndexNode + 1);
                double cost = length + (this.costIndexEdge >= 0 ? edge.getCostAt(this.costIndexEdge) : 0.0) + (this.costIndexNode >= 0 ? other.getCostAt(this.costIndexNode) : 0.0);
                if (persist.containsKey(other)) continue;
                if (!predecessors.containsKey(other)) {
                    System.err.println("init with " + cost);
                    other.setValueAt(0, 2);
                    other.setValueAt(1, (int)cost);
                    queue.insertElement(other, cost);
                    predecessors.put(other, edge);
                    counts.put(other, count + 1);
                    continue;
                }
                double before = (Double)queue.getValue(other);
                if (before > cost) {
                    System.err.println("change from " + before + " to " + cost);
                    other.setValueAt(0, 3);
                    other.setValueAt(1, (int)cost);
                    queue.changeElement(other, cost);
                    predecessors.put(other, edge);
                    counts.put(other, count + 1);
                    continue;
                }
                other.setValueAt(0, 7);
            }
            this.finishStep();
            node.setValueAt(0, 6);
        }
        int col = 1;
        for (Vector vector : result) {
            for (Node node : vector) {
                node.setValueAt(0, col);
                this.finishStep();
            }
            ++col;
        }
        this.nodes = result;
    }

    @Override
    public int preCalcSteps() {
        return this.graph.getNodeCount() + 1;
    }
}

