/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractMatching;
import org.ktde.math.graph.algo.AbstractMinTsp;
import org.ktde.math.graph.algo.AbstractPartialPairShortestPath;
import org.ktde.math.graph.algo.AbstractSpanningTree;
import org.ktde.math.graph.algo.AllPairShortestPathCompleteGraph;
import org.ktde.math.graph.algo.AlternatingTreeMatching;
import org.ktde.math.graph.algo.DijkstraPairPathFinder;
import org.ktde.math.graph.algo.EulerianTourFinder;
import org.ktde.math.graph.algo.HierholzerEulerianTourFinder;
import org.ktde.math.graph.algo.KruskalSpanningTree;
import org.ktde.math.graph.algo.UnevenDegreeNodeSet;

public class ChristophidesMinTspFinder
extends AbstractMinTsp {
    protected AbstractMatching matching;
    protected AbstractPartialPairShortestPath pair;
    protected AbstractSpanningTree spanningtree;
    private EulerianTourFinder etf;

    public ChristophidesMinTspFinder(Graph graph, int costIndexEdge) {
        this(graph, costIndexEdge, -1);
    }

    public ChristophidesMinTspFinder(Graph graph, int costIndexEdge, int costIndexNode) {
        this(graph, costIndexEdge, costIndexNode, new AlternatingTreeMatching(graph), new KruskalSpanningTree(graph, costIndexEdge));
    }

    public ChristophidesMinTspFinder(Graph graph, int costIndexEdge, int costIndexNode, AbstractMatching matching, AbstractSpanningTree spanningtree) {
        this(graph, costIndexEdge, costIndexNode, matching, spanningtree, new DijkstraPairPathFinder(graph, costIndexEdge));
    }

    public ChristophidesMinTspFinder(Graph graph, int costIndexEdge, int costIndexNode, AbstractMatching matching, AbstractSpanningTree spanningtree, AbstractPartialPairShortestPath pair) {
        this(graph, costIndexEdge, costIndexNode, matching, spanningtree, new DijkstraPairPathFinder(graph, costIndexEdge), new HierholzerEulerianTourFinder(graph));
    }

    public ChristophidesMinTspFinder(Graph graph, int costIndexEdge, int costIndexNode, AbstractMatching matching, AbstractSpanningTree spanningtree, AbstractPartialPairShortestPath pair, EulerianTourFinder etf) {
        super(graph, costIndexEdge, costIndexNode);
        this.matching = matching;
        this.spanningtree = spanningtree;
        this.pair = pair;
        this.etf = etf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void perform() {
        this.spanningtree.setGraph(this.graph);
        Graph spanning = this.spanningtree.findResultGraph();
        Graph uneven = new UnevenDegreeNodeSet(spanning).findResultGraph();
        this.pair.setNodeSet(uneven);
        Graph weighgraph = new AllPairShortestPathCompleteGraph(uneven, this.pair, false).findResultGraph();
        this.matching.setGraph(weighgraph);
        Graph addEdges = this.matching.findResultGraph();
        spanning.addEdges(addEdges);
        this.etf.setGraph(spanning);
        Vector<Edge<?>> etftour = this.etf.findTour();
        this.tour = new Vector(etftour.size());
        Iterator<Edge<?>> iterator = this.graph.getEdgeIterator();
        while (iterator.hasNext()) {
            Edge<?> e = iterator.next();
            e.setValueAt(0, 11);
        }
        Node<?> curNode = etftour.get(0).getStart();
        for (Edge edge : etftour) {
            if (this.graph.existsEdge(edge)) {
                this.tour.add(edge);
            } else {
                List<Edge<?>> origEges = this.extractEdgeList(edge);
                if (edge.getStart() != curNode) {
                    Collections.reverse(origEges);
                }
                for (Edge<?> edge2 : origEges) {
                    this.tour.add(edge2);
                }
            }
            curNode = edge.getOther(curNode);
        }
        if (this.wasSuccessfull()) {
            Edge lastEdge = null;
            Object var8_9 = null;
            Edge lastEdge3 = null;
            Node<?> lastNode = null;
            Node<?> lastNode2 = null;
            Node<?> lastNode3 = null;
            Node<?> lastNode4 = null;
            for (Edge edge : this.tour) {
                void var8_10;
                lastEdge3 = var8_10;
                Edge edge2 = lastEdge;
                lastEdge = edge;
                lastNode4 = lastNode3;
                lastNode3 = lastNode2;
                lastNode2 = lastNode;
                if (lastNode != null) {
                    lastNode = edge.getOther(lastNode);
                } else {
                    edge.getStart().setValueAt(0, 8);
                    lastNode = edge.getTarget();
                }
                if (lastEdge3 != null) {
                    lastEdge3.setValueAt(0, 0);
                }
                if (lastNode4 != null) {
                    lastNode4.setValueAt(0, 0);
                }
                lastEdge.setValueAt(0, 8);
                lastNode.setValueAt(0, 8);
                this.finishStep();
            }
        }
    }

    private List<Edge<?>> extractEdgeList(Edge<?> edge) {
        return (List)edge.getAssociatedObject();
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }
}

