/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Vector;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.algo.AbstractGraphAlgorithm;
import org.ktde.util.datatypes.Tupel;

public class AlternatingTreeFinder
extends AbstractGraphAlgorithm {
    protected Graph tree;
    protected Graph marked;
    protected int valueIndex;
    protected Vector<Node<?>> leaves;
    protected Edge<?> start;

    public AlternatingTreeFinder(Graph graph) {
        super(graph);
    }

    public AlternatingTreeFinder(Graph graph, Graph marked, Edge<?> start) {
        super(graph);
        this.start = start;
        this.marked = marked;
    }

    @Override
    protected void perform() {
        Edge<?> next;
        boolean hasTargetNode;
        this.tree = new Graph();
        Vector process = new Vector();
        this.leaves = new Vector();
        Node<?> startNode = this.start.getStart();
        Node<?> targetNode = this.start.getTarget();
        boolean hasStartNode = this.marked.existsNode(startNode) && this.marked.getEdgeCount(startNode) > 0;
        boolean bl = hasTargetNode = this.marked.existsNode(targetNode) && this.marked.getEdgeCount(targetNode) > 0;
        if (hasStartNode && hasTargetNode) {
            return;
        }
        if (!hasStartNode && !hasTargetNode) {
            this.leaves.add(targetNode);
            this.tree.addEdge(this.start);
            return;
        }
        this.start.setValueAt(0, 7);
        this.finishStep();
        this.tree.addEdge(this.start);
        if (hasStartNode) {
            next = this.marked.getEdgeAt(startNode, 0);
            process.add(next.getOther(startNode));
            this.tree.addEdge(next);
            next.setValueAt(0, 6);
        } else {
            next = this.marked.getEdgeAt(targetNode, 0);
            process.add(next.getOther(targetNode));
            this.tree.addEdge(next);
            next.setValueAt(0, 6);
        }
        for (int i = 0; i < process.size(); ++i) {
            Node current = (Node)process.elementAt(i);
            int countEdges = this.graph.existsNode(current) ? this.graph.getEdgeCount(current) : 0;
            for (int j = 0; j < countEdges; ++j) {
                int countFurther;
                Edge<?> edge = this.graph.getEdgeAt(current, j);
                Node<?> otherNode = edge.getOther(current);
                current.setValueAt(0, 3);
                if (this.tree.existsNode(otherNode)) continue;
                this.tree.addEdge(edge);
                edge.setValueAt(0, 7);
                int n = countFurther = this.marked.existsNode(otherNode) ? this.marked.getEdgeCount(otherNode) : 0;
                if (countFurther == 0) {
                    this.leaves.add(otherNode);
                    otherNode.setValueAt(0, 5);
                } else {
                    otherNode.setValueAt(0, 4);
                    Edge<?> next2 = this.marked.getEdgeAt(otherNode, 0);
                    this.tree.addEdge(next2);
                    process.add(next2.getOther(otherNode));
                    this.tree.addEdge(next2);
                    next2.setValueAt(0, 6);
                }
                this.finishStep();
            }
            this.finishStep();
        }
    }

    public Tupel<Graph, Vector<Node<?>>> findTree(Graph marked, Edge<?> start) {
        this.start = start;
        this.marked = marked;
        this.start(false);
        return new Tupel(this.tree, this.leaves);
    }

    @Override
    public int preCalcSteps() {
        return 0;
    }
}

