/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph.algo;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;
import org.ktde.math.graph.ObservableEdge;
import org.ktde.math.graph.algo.AbstractAllPairShortestPath;
import org.ktde.math.graph.algo.AbstractResultgraph;
import org.ktde.util.datatypes.Tupel;

public class AllPairShortestPathCompleteGraph
extends AbstractResultgraph {
    protected AbstractAllPairShortestPath algorithm;
    protected boolean directed;

    public AllPairShortestPathCompleteGraph(Graph graph, AbstractAllPairShortestPath algorithm, boolean directed) {
        super(graph);
        this.algorithm = algorithm;
        this.directed = directed;
    }

    public AllPairShortestPathCompleteGraph(Graph graph, AbstractAllPairShortestPath algorithm) {
        this(graph, algorithm, true);
    }

    @Override
    protected void perform() {
        this.algorithm.start(false);
        Hashtable<Tupel<Node<?>, Node<?>>, List<Edge<?>>> paths = this.algorithm.getPaths();
        Hashtable<Tupel<Object, Object>, Boolean> visited = null;
        if (!this.directed) {
            visited = new Hashtable<Tupel<Object, Object>, Boolean>();
        }
        Hashtable<Tupel<Node<?>, Node<?>>, Double> costs = this.algorithm.getCosts();
        Tupel<Object, Object> tupelij = new Tupel<Object, Object>(null, null);
        this.resultGraph.addNodes(this.graph);
        Iterator<Node<?>> iterator = this.graph.getNodeIterator();
        while (iterator.hasNext()) {
            Node<?> i = iterator.next();
            tupelij.setElement1(i);
            Iterator<Node<?>> iterator2 = this.graph.getNodeIterator();
            while (iterator2.hasNext()) {
                ObservableEdge newEdge;
                Node<?> j = iterator2.next();
                if (i == j) continue;
                tupelij.setElement2(j);
                List<Edge<?>> path = paths.get(tupelij);
                Double c = costs.get(tupelij);
                if (c == null) {
                    c = Double.POSITIVE_INFINITY;
                }
                if (this.directed) {
                    newEdge = new ObservableEdge(path, i, j, true, new double[]{c});
                    this.resultGraph.addEdge(newEdge);
                    continue;
                }
                if (visited.containsKey(tupelij)) continue;
                System.out.println("new " + tupelij);
                newEdge = new ObservableEdge(path, i, j, false, new double[]{c});
                this.resultGraph.addEdge(newEdge);
                tupelij.setElement1(j);
                tupelij.setElement2(i);
                visited.put(tupelij, true);
                tupelij.setElement1(i);
            }
        }
    }

    @Override
    public int preCalcSteps() {
        return this.algorithm.preCalcSteps() + this.graph.getNodeCount() * this.graph.getNodeCount();
    }
}

