/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.ktde.math.graph.Node;

public class ObservableNode<T>
extends Node<T> {
    private EventListenerList listeners = new EventListenerList();

    public ObservableNode() {
    }

    public ObservableNode(double[] cost) {
        super(cost);
    }

    public ObservableNode(double[] cost, int countValues) {
        super(cost, countValues);
    }

    public ObservableNode(double[] cost, int[] values) {
        super(cost, values);
    }

    public ObservableNode(T associatedObject) {
        super(associatedObject);
    }

    public ObservableNode(T associatedObject, double[] cost) {
        super(associatedObject, cost);
    }

    public ObservableNode(T associatedObject, double[] cost, int countValues) {
        super(associatedObject, cost, countValues);
    }

    public ObservableNode(T associatedObject, double[] cost, int[] values) {
        super(associatedObject, cost, values);
    }

    @Override
    public void setValueAt(int index, int value) {
        super.setValueAt(index, value);
        this.fireChangeEvent();
    }

    @Override
    public void setCostAt(int index, double cost) {
        super.setCostAt(index, cost);
        this.fireChangeEvent();
    }

    @Override
    public void setAssociatedObject(T associatedObject) {
        super.setAssociatedObject(associatedObject);
        this.fireChangeEvent();
    }

    public void addValueChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeValueChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(event);
        }
    }
}

