/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Graph;
import org.ktde.math.graph.Node;

public class ObservableGraph
extends Graph {
    private EventListenerList listeners = new EventListenerList();

    @Override
    public void addEdge(Edge<?> edge) {
        super.addEdge(edge);
        this.fireChangeEvent();
    }

    @Override
    public void addNode(Node<?> node) {
        super.addNode(node);
        this.fireChangeEvent();
    }

    @Override
    public void removeEdge(Edge<?> edge) {
        super.removeEdge(edge);
        this.fireChangeEvent();
    }

    @Override
    public void removeNode(Node<?> node) {
        super.removeNode(node);
        this.fireChangeEvent();
    }

    @Override
    public void addNodes(Graph graph) {
        super.addNodes(graph);
        this.fireChangeEvent();
    }

    @Override
    public void addEdges(Graph graph) {
        super.addEdges(graph);
        this.fireChangeEvent();
    }

    public void addValueChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeValueChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(event);
        }
    }
}

