/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import java.util.Hashtable;
import org.ktde.math.graph.Node;

public class ExtendedNode
extends Node<Node<?>> {
    protected Hashtable<Integer, Boolean> passedValues;
    protected Hashtable<Integer, Boolean> passedCosts;

    public ExtendedNode(Node<?> origin, boolean passCosts, boolean passValues) {
        this(origin, new Hashtable<Integer, Boolean>(), new Hashtable<Integer, Boolean>());
        int i;
        if (passCosts) {
            for (i = 0; i < origin.cost.length; ++i) {
                this.passedCosts.put(i, true);
            }
        }
        if (passValues) {
            for (i = 0; i < origin.values.length; ++i) {
                this.passedValues.put(i, true);
            }
        }
    }

    public ExtendedNode(Node<?> origin, Hashtable<Integer, Boolean> passedCosts, Hashtable<Integer, Boolean> passedValues) {
        super(origin, (double[])origin.cost.clone(), (int[])origin.values.clone());
        this.passedCosts = passedCosts;
        this.passedValues = passedValues;
    }

    @Override
    public int getValueAt(int index) {
        if (this.passedValues.containsKey(index)) {
            return ((Node)this.associatedObject).getValueAt(index);
        }
        return super.getValueAt(index);
    }

    @Override
    public void setValueAt(int index, int value) {
        if (this.passedValues.containsKey(index)) {
            ((Node)this.associatedObject).setValueAt(index, value);
        } else {
            super.setValueAt(index, value);
        }
    }

    @Override
    public double getCostAt(int index) {
        if (this.passedValues.containsKey(index)) {
            return ((Node)this.associatedObject).getCostAt(index);
        }
        return super.getCostAt(index);
    }

    @Override
    public void setCostAt(int index, double cost) {
        if (this.passedValues.containsKey(index)) {
            ((Node)this.associatedObject).setCostAt(index, cost);
        } else {
            super.setCostAt(index, cost);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }
}

