/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import java.util.Hashtable;
import org.ktde.math.graph.Edge;
import org.ktde.math.graph.Node;

public class ExtendedEdge
extends Edge<Edge<?>> {
    protected Hashtable<Integer, Boolean> passedValues;
    protected Hashtable<Integer, Boolean> passedCosts;

    public ExtendedEdge(Node<?> start, Node<?> target, boolean directed, Edge<?> origin, boolean passCosts, boolean passValues) {
        this(start, target, directed, origin, new Hashtable<Integer, Boolean>(), new Hashtable<Integer, Boolean>());
        int i;
        if (passCosts) {
            for (i = 0; i < origin.cost.length; ++i) {
                this.passedCosts.put(i, true);
            }
        }
        if (passValues) {
            for (i = 0; i < origin.values.length; ++i) {
                this.passedValues.put(i, true);
            }
        }
    }

    public ExtendedEdge(Node<?> start, Node<?> target, boolean directed, Edge<?> origin, Hashtable<Integer, Boolean> passedCosts, Hashtable<Integer, Boolean> passedValues) {
        super(origin, start, target, directed, (double[])origin.cost.clone(), (int[])origin.values.clone());
        this.passedCosts = passedCosts;
        this.passedValues = passedValues;
    }

    @Override
    public int getValueAt(int index) {
        if (this.passedValues.containsKey(index)) {
            return ((Edge)this.associatedObject).getValueAt(index);
        }
        return super.getValueAt(index);
    }

    @Override
    public void setValueAt(int index, int value) {
        if (this.passedValues.containsKey(index)) {
            ((Edge)this.associatedObject).setValueAt(index, value);
        } else {
            super.setValueAt(index, value);
        }
    }

    @Override
    public double getCostAt(int index) {
        if (this.passedValues.containsKey(index)) {
            return ((Edge)this.associatedObject).getCostAt(index);
        }
        return super.getCostAt(index);
    }

    @Override
    public void setCostAt(int index, double cost) {
        if (this.passedValues.containsKey(index)) {
            ((Edge)this.associatedObject).setCostAt(index, cost);
        } else {
            super.setCostAt(index, cost);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }
}

