/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.graph;

import org.ktde.math.graph.Node;

public class Edge<T> {
    protected T associatedObject;
    protected boolean directed;
    protected int[] values;
    protected double[] cost;
    protected Node<?> start;
    protected Node<?> target;

    public Edge(Node<?> start, Node<?> target) {
        this(start, target, new double[]{0.0});
    }

    public Edge(Node<?> start, Node<?> target, boolean directed, double[] cost) {
        this(null, start, target, directed, cost, new int[0]);
    }

    public Edge(Node<?> start, Node<?> target, double[] cost) {
        this(null, start, target, false, cost, new int[0]);
    }

    public Edge(Node<?> start, Node<?> target, boolean directed, double[] cost, int countValues) {
        this(null, start, target, directed, cost, new int[countValues]);
    }

    public Edge(Node<?> start, Node<?> target, double[] cost, int countValues) {
        this(null, start, target, false, cost, new int[countValues]);
    }

    public Edge(Node<?> start, Node<?> target, double[] cost, int[] values) {
        this(null, start, target, false, cost, values);
    }

    public Edge(Node<?> start, Node<?> target, boolean directed, double[] cost, int[] values) {
        this(null, start, target, directed, cost, values);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target) {
        this(associatedObject, start, target, new double[]{0.0});
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, boolean directed, double[] cost) {
        this(associatedObject, start, target, directed, cost, new int[0]);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, double[] cost) {
        this(associatedObject, start, target, false, cost, new int[0]);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, boolean directed, double[] cost, int countValues) {
        this(associatedObject, start, target, directed, cost, new int[countValues]);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, double[] cost, int countValues) {
        this(associatedObject, start, target, false, cost, new int[countValues]);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, double[] cost, int[] values) {
        this(associatedObject, start, target, false, cost, values);
    }

    public Edge(T associatedObject, Node<?> start, Node<?> target, boolean directed, double[] cost, int[] values) {
        this.associatedObject = associatedObject;
        this.start = start;
        this.target = target;
        this.directed = directed;
        this.cost = cost;
        this.values = values;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public void setValueAt(int index, int value) {
        this.values[index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertValueCount(int count) {
        if (this.values.length < count) {
            Edge edge = this;
            synchronized (edge) {
                int[] newValues = new int[count];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
            }
        }
    }

    public double getCostAt(int index) {
        return this.cost[index];
    }

    public void setCostAt(int index, double cost) {
        this.cost[index] = cost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertCostCount(int count) {
        if (this.cost.length < count) {
            Edge edge = this;
            synchronized (edge) {
                double[] newCost = new double[count];
                System.arraycopy(this.cost, 0, newCost, 0, this.cost.length);
                this.cost = newCost;
            }
        }
    }

    public double[] getCost() {
        return this.cost;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public Node<?> getStart() {
        return this.start;
    }

    public Node<?> getTarget() {
        return this.target;
    }

    public T getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(T associatedObject) {
        this.associatedObject = associatedObject;
    }

    public String toString() {
        return this.associatedObject == null ? "" + this.hashCode() : this.associatedObject.toString();
    }

    public Node<?> getOther(Node<?> node) {
        return this.start.equals(node) ? this.target : (this.target.equals(node) ? this.start : null);
    }

    public int hashCode() {
        return this.associatedObject == null ? 0 : this.associatedObject.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Edge) {
            Edge edge = (Edge)obj;
            result = this.associatedObject == null != (edge.associatedObject == null) ? false : (this.associatedObject == null ? true : this.associatedObject.equals(edge.associatedObject));
        }
        return result;
    }
}

