/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.types.doubletype;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.geom.types.Point;

public class Polygon
extends org.ktde.math.geom.types.Polygon<Double> {
    public Polygon(List<Point<Double>> list) {
        super(list);
    }

    public static Polygon createInstance(List<? extends Point<Double>> result) {
        ArrayList<Point<Double>> convlist = new ArrayList<Point<Double>>();
        for (Point<Double> point : result) {
            convlist.add(point);
        }
        return new Polygon((List<Point<Double>>)convlist);
    }

    @Override
    public boolean ccw(Double p1x, Double p1y, Double p2x, Double p2y, Double p3x, Double p3y) {
        double dy2;
        double dx2;
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        return dy1 * (dx2 = p3x - p2x) < (dy2 = p3y - p2y) * dx1;
    }

    @Override
    public boolean isDirected() {
        double area = 0.0;
        for (int i = 1; i < this.getPointCount() + 1; ++i) {
            double x1 = (Double)this.getPointAt(i - 1).getX();
            double y1 = (Double)this.getPointAt(i - 1).getY();
            double x2 = (Double)this.getPointAt(i % this.getPointCount()).getX();
            double y2 = (Double)this.getPointAt(i % this.getPointCount()).getY();
            double change = x1 * y2 - x2 * y1;
            area += change;
        }
        return area > 0.0;
    }
}

