/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.types;

import java.util.ArrayList;
import java.util.List;
import org.ktde.math.geom.types.Linestring;
import org.ktde.math.geom.types.Point;
import org.ktde.math.geom.types.Polygon;

public abstract class SegmentedPolygon<T>
extends Polygon<T> {
    private List<Linestring<T>> linestrings = new ArrayList<Linestring<T>>();

    public SegmentedPolygon(List<Linestring<T>> linestrings) {
        super(null);
        Linestring<T> lastlinestring = linestrings.get(linestrings.size() - 1);
        for (Linestring<T> linestring : linestrings) {
            if (!linestring.getFirstPoint().equals(lastlinestring.getLastPoint())) {
                this.linestrings.add(linestring.unshift(lastlinestring.getLastPoint()));
            } else {
                this.linestrings.add(linestring.replaceFirst(lastlinestring.getLastPoint()));
            }
            lastlinestring = linestring;
        }
    }

    @Override
    public Point<T> getPointAt(int index) {
        int i = index;
        for (Linestring<T> linestring : this.linestrings) {
            int size = linestring.getPointCount();
            if (size - 1 > i) {
                return linestring.getPointAt(i);
            }
            i -= size - 1;
        }
        throw new IndexOutOfBoundsException(index + ">" + this.getPointCount());
    }

    @Override
    public int getPointCount() {
        int c = 0;
        for (Linestring<T> linestring : this.linestrings) {
            int size = linestring.getPointCount();
            c += size - 1;
        }
        return c;
    }

    public Linestring<T> getLinestringAt(int index) {
        return this.linestrings.get(index);
    }

    public int getLineCount() {
        return this.linestrings.size();
    }
}

