/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand.polyshrink;

import org.ktde.math.geom.algorithm.sand.PointFunction;
import org.ktde.math.geom.types.doubletype.MutablePoint;
import org.ktde.util.datatypes.Tupel;

public class ShrinkingPoint
extends MutablePoint {
    private double ox;
    private double oy;
    private PointFunction function;
    private double fac;
    private boolean blocked;

    public ShrinkingPoint(double x, double y, PointFunction function) {
        super(x, y);
        this.ox = x;
        this.oy = y;
        this.function = function;
        this.fac = 0.0;
        this.blocked = false;
    }

    public PointFunction getFunction() {
        return this.function;
    }

    public void setFunction(PointFunction function) {
        this.function = function;
    }

    public boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public double getFac() {
        return this.fac;
    }

    public void setFac(double fac) {
        this.fac = fac = this.function.checkFac(fac);
        Tupel<Double, Double> delta = this.function.getDelta(fac);
        this.setX(this.ox + delta.getElement1());
        this.setY(this.oy + delta.getElement2());
    }

    public ShrinkingPoint getShrinkedPoint(double fac) {
        if (this.blocked) {
            return this;
        }
        double x = this.ox;
        double y = this.oy;
        fac += this.fac;
        if (this.function != null) {
            fac = this.function.checkFac(fac);
            Tupel<Double, Double> delta = this.function.getDelta(fac);
            x += delta.getElement1().doubleValue();
            y += delta.getElement2().doubleValue();
        }
        ShrinkingPoint shrink = new ShrinkingPoint(x, y, this.function);
        shrink.fac = fac;
        shrink.ox = this.ox;
        shrink.oy = this.oy;
        shrink.blocked = this.blocked;
        return shrink;
    }

    public ShrinkingPoint between(ShrinkingPoint other) {
        double x = ((Double)this.getX() + (Double)other.getX()) / 2.0;
        double y = ((Double)this.getY() + (Double)other.getY()) / 2.0;
        ShrinkingPoint newPoint = new ShrinkingPoint(x, y, null);
        return newPoint;
    }

    @Override
    public Object clone() {
        ShrinkingPoint shrink = new ShrinkingPoint((Double)this.getX(), (Double)this.getY(), this.function);
        shrink.fac = this.fac;
        shrink.ox = this.ox;
        shrink.oy = this.oy;
        shrink.blocked = this.blocked;
        return shrink;
    }
}

