/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.ktde.math.geom.algorithm.sand.AngleSectPoint;
import org.ktde.math.geom.algorithm.sand.SideDef;
import org.ktde.math.geom.algorithm.sand.polyshrink.ShrinkingPoint;
import org.ktde.math.geom.types.Point;
import org.ktde.math.geom.types.doubletype.MutablePoint;
import org.ktde.math.geom.types.doubletype.Polygon;

public class PolyshrinkDebug
extends JFrame
implements MouseMotionListener,
MouseListener,
ActionListener {
    public final double FACTOR = 1.0;
    public static final boolean DEBUG = true;
    private static final long serialVersionUID = 6542538842747281621L;
    private List<Polygon> polys;
    private List<Color> colors;
    private Polygon poly;
    private double startX;
    private double startY;
    private MutablePoint curpoint;
    private Double saveY;
    private Double saveX;
    private Polygon curWork;
    private Polygon outer;
    private Polygon side;
    private Polygon bounds;
    private double offx = 0.0;
    private double offy = 600.0;

    public PolyshrinkDebug() {
        super("Polyshrink");
        JLabel canvas = new JLabel(" "){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                PolyshrinkDebug.this.paintComponent((Graphics2D)g);
            }
        };
        this.getContentPane().add((Component)canvas, "Center");
        JButton button = new JButton("Test Streets");
        this.getContentPane().add((Component)button, "South");
        button.addActionListener(this);
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(3);
        canvas.addMouseMotionListener(this);
        canvas.addMouseListener(this);
        this.colors = new ArrayList<Color>();
        this.colors.add(Color.BLACK);
        this.colors.add(Color.RED);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.BLUE);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.YELLOW);
        ArrayList<MutablePoint> polyArray = new ArrayList<MutablePoint>();
        polyArray.add(new MutablePoint(40.0, 0.0));
        polyArray.add(new MutablePoint(40.0, 10.0));
        polyArray.add(new MutablePoint(80.0, 60.0));
        polyArray.add(new MutablePoint(70.0, 70.0));
        polyArray.add(new MutablePoint(60.5, 60.5));
        polyArray.add(new MutablePoint(70.0, 70.0));
        polyArray.add(new MutablePoint(60.0, 80.0));
        polyArray.add(new MutablePoint(10.0, 60.0));
        polyArray.add(new MutablePoint(10.0, 10.0));
        this.poly = Polygon.createInstance(polyArray);
        this.polys = new ArrayList<Polygon>();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PolyshrinkDebug.this.buildPolys();
                PolyshrinkDebug.this.repaint();
            }
        }.start();
        this.setVisible(true);
    }

    private void buildPolys() {
        int i;
        Polygon nextpoly;
        this.polys = new ArrayList<Polygon>();
        this.outer = this.convertPoly(this.poly);
        this.polys.add(this.outer);
        this.repaint(10L);
        double area = 0.0;
        for (int i2 = 1; i2 < this.poly.getPointCount() + 1; ++i2) {
            double x1 = (Double)this.poly.getPointAt(i2 - 1).getX();
            double y1 = (Double)this.poly.getPointAt(i2 - 1).getY();
            double x2 = (Double)this.poly.getPointAt(i2 % this.poly.getPointCount()).getX();
            double y2 = (Double)this.poly.getPointAt(i2 % this.poly.getPointCount()).getY();
            double change = x1 * y2 - x2 * y1;
            area += change;
        }
        if (area < 0.0) {
            return;
        }
        Polygon curpoly = nextpoly = this.shrink(this.outer, 0.001, true);
        nextpoly = this.shrink(curpoly, 1.999, false);
        this.polys.add(nextpoly);
        curpoly = nextpoly;
        for (i = 0; i < 6; ++i) {
            nextpoly = this.shrink(curpoly, 2.0, false);
            this.polys.add(nextpoly);
            curpoly = nextpoly;
            if (i != 2) continue;
            this.side = curpoly;
        }
        this.bounds = this.shrink(curpoly, 1.0, false);
        for (i = 0; i < this.bounds.getPointCount(); ++i) {
            ShrinkingPoint shrinkingPoint = (ShrinkingPoint)this.bounds.getPointAt(i);
            double fac = shrinkingPoint.getFac();
            if (!(fac < 10.0)) continue;
            if (fac > 4.0) {
                ((ShrinkingPoint)this.side.getPointAt(i)).setFac(fac - 2.0);
                continue;
            }
            ((ShrinkingPoint)this.side.getPointAt(i)).setFac(fac / 2.0);
        }
    }

    private void addPoints(List<ShrinkingPoint> result, Point<Double> point, Point<Double> prev, Point<Double> next) {
        double angle2;
        double x = point.getX();
        double y = point.getY();
        double x1 = prev.getX();
        double y1 = prev.getY();
        double x2 = next.getX();
        double y2 = next.getY();
        double deltax1 = x1 - x;
        double deltay1 = y1 - y;
        double deltax2 = x2 - x;
        double deltay2 = y2 - y;
        double angle1 = Math.atan2(deltay1, deltax1);
        double angle = PolyshrinkDebug.normalizeAngle(angle1 - (angle2 = Math.atan2(deltay2, deltax2)), false);
        if (angle > Math.PI) {
            int countPoints = 1;
            countPoints = angle < 3.9269908169872414 ? 3 : (angle < 4.71238898038469 ? 4 : (angle < 5.497787143782138 ? 6 : (angle < Math.PI * 2 ? 8 : 10)));
            double anglestep = (angle - Math.PI) / (double)(countPoints - 1);
            double curAngle = angle1 - 1.5707963267948966;
            for (int i = 0; i < countPoints; ++i) {
                ShrinkingPoint curpoint = new ShrinkingPoint(point.getX(), point.getY(), new AngleSectPoint(1.0, curAngle));
                result.add(curpoint);
                curAngle = PolyshrinkDebug.normalizeAngle(curAngle - anglestep);
            }
        } else {
            while (angle1 < angle2) {
                angle1 += Math.PI * 2;
            }
            double c = 1.0 / Math.sin(angle / 2.0);
            double a = PolyshrinkDebug.normalizeAngle((angle1 + angle2) / 2.0);
            ShrinkingPoint curpoint = new ShrinkingPoint(point.getX(), point.getY(), new AngleSectPoint(c, a));
            result.add(curpoint);
        }
    }

    private void setMax(ShrinkingPoint p1, ShrinkingPoint p2) {
        double angleb;
        double l = Math.sqrt(Math.pow((Double)p1.getX() - (Double)p2.getX(), 2.0) + Math.pow((Double)p1.getY() - (Double)p2.getY(), 2.0));
        if (l == 0.0) {
            return;
        }
        double angle = PolyshrinkDebug.normalizeAngle(Math.atan2((Double)p2.getY() - (Double)p1.getY(), (Double)p2.getX() - (Double)p1.getX()));
        double anglea = PolyshrinkDebug.normalizeAngle(((AngleSectPoint)p1.getFunction()).getAngle() - angle);
        if (anglea > 1.5707963267948966) {
            anglea = 1.5707963267948966;
        }
        if ((angleb = PolyshrinkDebug.normalizeAngle(Math.PI - (((AngleSectPoint)p2.getFunction()).getAngle() - angle))) > 1.5707963267948966) {
            angleb = 1.5707963267948966;
        }
        if (anglea == 1.5707963267948966 && angleb == 1.5707963267948966) {
            return;
        }
        double ta = Math.tan(anglea);
        double tb = Math.tan(angleb);
        double j = l * tb / (ta + tb);
        double s = j * ta;
        double h = s / Math.sin(angleb);
        double g = s / Math.sin(anglea);
        double he = h / l;
        double ge = g / l;
        ((AngleSectPoint)p1.getFunction()).setMax(g - ge);
        ((AngleSectPoint)p2.getFunction()).setMax(h - he);
    }

    private static double normalizeAngle(double angle) {
        return PolyshrinkDebug.normalizeAngle(angle, true);
    }

    private static double normalizeAngle(double angle, boolean boundZero) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle == 0.0 && !boundZero) {
            angle = Math.PI * 2;
        }
        return angle;
    }

    private Polygon convertPoly(Polygon poly) {
        ArrayList<ShrinkingPoint> result = new ArrayList<ShrinkingPoint>();
        int pointCount = poly.getPointCount();
        Point<Double> last = poly.getPointAt(pointCount - 2);
        Point<Double> cur = poly.getPointAt(pointCount - 1);
        for (int i = 0; i < pointCount; ++i) {
            Point<Double> next = poly.getPointAt(i);
            this.addPoints(result, cur, last, next);
            last = cur;
            cur = next;
        }
        if (result.size() > 2) {
            ShrinkingPoint p1 = (ShrinkingPoint)result.get(result.size() - 1);
            for (ShrinkingPoint p2 : result) {
                this.setMax(p1, p2);
                p1 = p2;
            }
        }
        return Polygon.createInstance(result);
    }

    private Polygon shrink(Polygon poly, double fac, boolean ignoreIntersect) {
        ArrayList<ShrinkingPoint> result = new ArrayList<ShrinkingPoint>();
        int pointCount = poly.getPointCount();
        for (int p = 0; p < pointCount; ++p) {
            result.add((ShrinkingPoint)poly.getPointAt(p));
        }
        this.curWork = Polygon.createInstance(result);
        for (int i = 0; i < result.size(); ++i) {
            ShrinkingPoint cur = (ShrinkingPoint)result.get(i);
            ShrinkingPoint shrinked = cur.getShrinkedPoint(fac);
            result.set(i, shrinked);
            this.curWork = Polygon.createInstance(result);
            boolean intersect = !ignoreIntersect && this.curWork.checkComplex();
            this.repaint(10L);
            if (!intersect) continue;
            result.set(i, cur);
            this.repaint(10L);
        }
        this.curWork = null;
        return Polygon.createInstance(result);
    }

    protected void paintComponent(Graphics2D g) {
        if (this.FACTOR < 2.0) {
            BasicStroke bf = new BasicStroke(2.0f);
            if (this.outer != null) {
                g.setStroke(bf);
                g.setColor(Color.black);
                this.drawPoly(g, this.outer, false);
            }
            if (this.side != null) {
                g.setStroke(bf);
                g.setColor(Color.BLUE);
                this.drawPoly(g, this.side, false);
            }
            if (this.bounds != null) {
                g.setStroke(bf);
                g.setColor(Color.RED);
                this.drawPoly(g, this.bounds, false);
            }
        } else {
            BasicStroke bf = new BasicStroke(4.0f);
            if (this.outer != null) {
                g.setStroke(bf);
                g.setColor(Color.black);
                this.drawPoly(g, this.outer, true);
            }
            if (this.side != null) {
                g.setStroke(bf);
                g.setColor(Color.BLUE);
                this.drawPoly(g, this.side, true);
            }
            if (this.bounds != null) {
                g.setStroke(bf);
                g.setColor(Color.RED);
                this.drawPoly(g, this.bounds, true);
            }
            BasicStroke b = new BasicStroke(1.0f);
            g.setStroke(b);
            for (int i = 0; i < this.polys.size(); ++i) {
                g.setColor(this.colors.get(i % this.colors.size()));
                Polygon curpoly = this.polys.get(i);
                this.drawPoly(g, curpoly, false);
            }
            if (this.curWork != null) {
                g.setStroke(b);
                g.setColor(this.colors.get(this.polys.size() % this.colors.size()));
                this.drawPoly(g, this.curWork, false);
            }
        }
    }

    private void drawPoly(Graphics2D g, Polygon poly, boolean drawPoints) {
        int pointCount = poly.getPointCount();
        Point lastPoint = poly.getPointAt(pointCount - 1);
        for (int p = 0; p < pointCount; ++p) {
            Point point = poly.getPointAt(p);
            g.drawLine((int)this.transformX((Double)lastPoint.getX()), (int)this.transformY((Double)lastPoint.getY()), (int)this.transformX((Double)point.getX()), (int)this.transformY((Double)point.getY()));
            if (drawPoints) {
                g.fillOval((int)this.transformX((Double)point.getX()) - 3, (int)this.transformY((Double)point.getY()) - 3, 6, 6);
            }
            lastPoint = point;
        }
    }

    public static boolean intersects(ShrinkingPoint p11, ShrinkingPoint p12, ShrinkingPoint p21, ShrinkingPoint p22) {
        boolean result = false;
        Line2D.Double l1 = new Line2D.Double((Double)p11.getX(), (Double)p11.getY(), (Double)p12.getX(), (Double)p12.getY());
        Line2D.Double l2 = new Line2D.Double((Double)p21.getX(), (Double)p21.getY(), (Double)p22.getX(), (Double)p22.getY());
        result = l1.intersectsLine(l2);
        return result;
    }

    public static void main(String[] args) {
        new PolyshrinkDebug();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.curpoint != null) {
            double cx = this.inverseTransformX(e.getX());
            double cy = this.inverseTransformY(e.getY());
            this.curpoint.setX(this.saveX + cx - this.startX);
            this.curpoint.setY(this.saveY + cy - this.startY);
            this.buildPolys();
        } else {
            double cx = e.getX();
            double cy = e.getY();
            this.offx = this.saveX + cx - this.startX;
            this.offy = this.saveY + cy - this.startY;
        }
        this.repaint(10L);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = this.inverseTransformX(e.getX());
        this.startY = this.inverseTransformY(e.getY());
        this.curpoint = null;
        int pointCount = this.poly.getPointCount();
        for (int p = 0; p < pointCount; ++p) {
            MutablePoint point = (MutablePoint)this.poly.getPointAt(p);
            double d1 = Math.sqrt(Math.pow(this.startX - (Double)point.getX(), 2.0) + Math.pow(this.startY - (Double)point.getY(), 2.0));
            if (!(d1 < 0.3)) continue;
            this.curpoint = point;
            this.saveX = (Double)this.curpoint.getX();
            this.saveY = (Double)this.curpoint.getY();
            break;
        }
        if (this.curpoint == null) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.saveX = this.offx;
            this.saveY = this.offy;
        }
    }

    public void gotoCoords(double x, double y) {
        this.offx = -x * this.FACTOR;
        this.offy = y * this.FACTOR + 600.0;
    }

    public double transformX(double x) {
        double tx = this.offx + x * this.FACTOR;
        return tx;
    }

    public double transformY(double y) {
        double ty = this.offy - y * this.FACTOR;
        return ty;
    }

    public double inverseTransformX(double x) {
        double tx = (x - this.offx) / this.FACTOR;
        return tx;
    }

    public double inverseTransformY(double y) {
        double ty = (this.offy - y) / this.FACTOR;
        return ty;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.curpoint = null;
    }

    public void analyzeSpeed() {
        Connection conn;
        try {
            Class.forName("org.postgresql.Driver");
            String host = "speedball.emanagers.lan";
            int port = 5432;
            String dbname = "gisimports_eu2008_2_de";
            String user = "postgres";
            String password = "damassa";
            conn = DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + dbname + "?user=" + user + "&password=" + password);
        }
        catch (Exception e) {
            conn = null;
            e.printStackTrace();
        }
        if (conn == null) {
            throw new IllegalStateException("DB not initialized");
        }
        try {
            String blocktable = "userdata_base.t_map_streetsegmentblock_eu2008_2_de_landpass";
            String sql = "SELECT id FROM " + blocktable + " WHERE ((id/3)::int4)*3=id ORDER BY id DESC";
            Statement statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            Hashtable timeHash = new Hashtable();
            ArrayList<Integer> timeKeys = new ArrayList<Integer>();
            while (resultSet.next()) {
                int blockid = resultSet.getInt("id");
                String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_landpass";
                sql = "SELECT COUNT(*) AS cnt FROM " + sidetable;
                sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
                statement = conn.createStatement();
                ResultSet resultSetCount = statement.executeQuery(sql);
                resultSetCount.next();
                int count = resultSetCount.getInt("cnt");
                resultSetCount.close();
                System.out.print("Process Block id " + blockid + " with " + count + " segments ");
                long t = System.currentTimeMillis();
                this.loadAndBuild(conn, blockid);
                long t2 = System.currentTimeMillis();
                System.out.println("in " + (double)(t2 - t) / 1000.0 + " sec build");
                if (!timeHash.containsKey(count)) {
                    timeHash.put(count, new ArrayList());
                    timeKeys.add(count);
                }
                ((List)timeHash.get(count)).add(t2 - t);
            }
            resultSet.close();
            Collections.sort(timeKeys);
            System.out.println("points,mean,min,max,dev,count");
            for (Integer count : timeKeys) {
                List list = (List)timeHash.get(count);
                double arithMean = this.getMean(list);
                double dev = this.getDeviation(list, arithMean);
                double min = this.getMin(list);
                double max = this.getMax(list);
                System.out.println(count + "," + (int)Math.round(arithMean) + "," + (int)Math.round(min) + "," + (int)Math.round(max) + "," + (int)Math.round(dev) + "," + list.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Connection conn;
        try {
            Class.forName("org.postgresql.Driver");
            String host = "speedball.emanagers.lan";
            int port = 5432;
            String dbname = "gisimports_eu2008_2_de";
            String user = "postgres";
            String password = "damassa";
            conn = DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + dbname + "?user=" + user + "&password=" + password);
        }
        catch (Exception e) {
            conn = null;
            e.printStackTrace();
        }
        if (conn == null) {
            throw new IllegalStateException("DB not initialized");
        }
        try {
            Statement statement = conn.createStatement();
            String blocktable = "userdata_base.t_map_streetsegmentblock_eu2008_2_de_landpass";
            String sql = "SELECT COUNT(*) AS cnt FROM " + blocktable;
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            int cnt = resultSet.getInt("cnt");
            resultSet.close();
            int fetchindex = (int)(Math.random() * (double)cnt);
            sql = "SELECT id FROM " + blocktable + " OFFSET " + fetchindex + " LIMIT 1";
            resultSet = statement.executeQuery(sql);
            resultSet.next();
            int blockid = resultSet.getInt("id");
            resultSet.close();
            String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_landpass";
            sql = "SELECT COUNT(*) AS cnt FROM " + sidetable;
            sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
            resultSet = statement.executeQuery(sql);
            resultSet.next();
            int count = resultSet.getInt("cnt");
            resultSet.close();
            System.out.print("Process Block id " + blockid + " with " + count + " segments ");
            long t = System.currentTimeMillis();
            this.loadAndBuild(conn, blockid);
            long t2 = System.currentTimeMillis();
            System.out.println("in " + (double)(t2 - t) / 1000.0 + " sec build");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double getMin(List<Long> list) {
        double m = Double.MAX_VALUE;
        for (Long l : list) {
            m = Math.min(m, (double)l.longValue());
        }
        return m;
    }

    private double getMax(List<Long> list) {
        double m = -1.7976931348623157E308;
        for (Long l : list) {
            m = Math.max(m, (double)l.longValue());
        }
        return m;
    }

    private double getDeviation(List<Long> list, Double arithMean) {
        if (arithMean == null) {
            arithMean = this.getMean(list);
        }
        double sum = 0.0;
        for (Long l : list) {
            double v = (double)l.longValue() - arithMean;
            sum += v * v;
        }
        return Math.sqrt(sum / (double)list.size());
    }

    private Double getMean(List<Long> list) {
        double sum = 0.0;
        for (Long l : list) {
            sum += (double)l.longValue();
        }
        return sum / (double)list.size();
    }

    private void loadAndBuild(Connection conn, int blockid) throws SQLException, ParseException {
        Statement statement = conn.createStatement();
        String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_landpass";
        String seggeomtable = "gis_base.t_segment_map_streetsegment_eu2008_2_de_landpass";
        String sql = "SELECT * FROM " + sidetable + " side";
        sql = sql + " JOIN " + seggeomtable + " seg ON side.id_map_streetsegment=seg.id";
        sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
        Hashtable<Integer, SideDef> hash = new Hashtable<Integer, SideDef>();
        ResultSet resultSet = statement.executeQuery(sql);
        WKBReader reader = new WKBReader();
        int startid = 0;
        int count = 0;
        while (resultSet.next()) {
            ++count;
            int sideid = resultSet.getInt("id");
            int nextid = resultSet.getInt("id_map_streetsegmentside_next");
            String geomhex = resultSet.getString("geom");
            String side = resultSet.getString("side");
            Geometry geom = reader.read(WKBReader.hexToBytes(geomhex));
            hash.put(sideid, new SideDef(sideid, nextid, geom, side.equalsIgnoreCase("l")));
            startid = sideid;
        }
        resultSet.close();
        ArrayList<MutablePoint> polyArray = new ArrayList<MutablePoint>();
        double left = Double.MAX_VALUE;
        double bottom = Double.MAX_VALUE;
        for (int p = 0; p < count; ++p) {
            SideDef curdef = (SideDef)hash.get(startid);
            ArrayList<MutablePoint> polypart = p == 0 ? polyArray : new ArrayList<MutablePoint>();
            LineString line = (LineString)curdef.getGeom();
            for (int i = 0; i < line.getNumPoints(); ++i) {
                com.vividsolutions.jts.geom.Point point = line.getPointN(i);
                polypart.add(new MutablePoint(point.getX(), point.getY()));
                left = Math.min(left, point.getX());
                bottom = Math.min(bottom, point.getY());
            }
            if (!curdef.isDirection()) {
                ArrayList polypartmirror = new ArrayList();
                for (int i = polypart.size() - 1; i >= 0; --i) {
                    polypartmirror.add(polypart.get(i));
                }
                if (p == 0) {
                    polyArray = polypartmirror;
                } else {
                    polypart = polypartmirror;
                }
            }
            if (p > 0) {
                if (((MutablePoint)polypart.get(0)).equals((Point)polyArray.get(polyArray.size() - 1))) {
                    polypart.remove(0);
                }
                polyArray.addAll(polypart);
            }
            startid = curdef.getNextid();
        }
        if (((MutablePoint)polyArray.get(0)).equals((Point)polyArray.get(polyArray.size() - 1))) {
            polyArray.remove(0);
        }
        this.poly = Polygon.createInstance(polyArray);
        this.gotoCoords(left, bottom);
        this.buildPolys();
    }
}

