/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.ktde.math.ComputeStatistics;
import org.ktde.math.geom.algorithm.sand.PolyShrinkAlgorithm;
import org.ktde.math.geom.algorithm.sand.SideDef;
import org.ktde.math.geom.types.Linestring;
import org.ktde.math.geom.types.Point;
import org.ktde.math.geom.types.doubletype.MutablePoint;
import org.ktde.math.geom.types.doubletype.SegmentedPolygon;
import org.ktde.util.datatypes.Tupel;

public class Polyshrink
extends JFrame
implements MouseMotionListener,
MouseListener,
ActionListener {
    public final double FACTOR = 2.0;
    static Hashtable<String, Integer> profile;
    private static final long serialVersionUID = 6542538842747281621L;
    private List<Color> colors;
    private SegmentedPolygon poly;
    private double startX;
    private double startY;
    private MutablePoint curpoint;
    private Double saveY;
    private Double saveX;
    private SegmentedPolygon outer;
    private SegmentedPolygon side;
    private SegmentedPolygon bounds;
    private ArrayList<Tupel<Point<Double>, Point<Double>>> net;
    private double offx = 0.0;
    private double offy = 600.0;

    public Polyshrink() {
        super("Polyshrink");
        JLabel canvas = new JLabel(" "){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Polyshrink.this.paintComponent((Graphics2D)g);
            }
        };
        this.getContentPane().add((Component)canvas, "Center");
        JButton button = new JButton("Test Streets");
        this.getContentPane().add((Component)button, "South");
        button.addActionListener(this);
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(3);
        canvas.addMouseMotionListener(this);
        canvas.addMouseListener(this);
        this.colors = new ArrayList<Color>();
        this.colors.add(Color.BLACK);
        this.colors.add(Color.RED);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.BLUE);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.YELLOW);
        ArrayList<org.ktde.math.geom.types.doubletype.Linestring> polyArray = new ArrayList<org.ktde.math.geom.types.doubletype.Linestring>();
        ArrayList<MutablePoint> lineArray = new ArrayList<MutablePoint>();
        lineArray.add(new MutablePoint(400.0, 0.0));
        lineArray.add(new MutablePoint(400.0, 100.0));
        lineArray.add(new MutablePoint(800.0, 600.0));
        polyArray.add(org.ktde.math.geom.types.doubletype.Linestring.createInstance(lineArray));
        lineArray = new ArrayList();
        lineArray.add(new MutablePoint(800.0, 600.0));
        lineArray.add(new MutablePoint(700.0, 700.0));
        lineArray.add(new MutablePoint(600.5, 600.5));
        lineArray.add(new MutablePoint(700.0, 700.0));
        lineArray.add(new MutablePoint(600.0, 800.0));
        lineArray.add(new MutablePoint(100.0, 600.0));
        lineArray.add(new MutablePoint(100.0, 100.0));
        lineArray.add(new MutablePoint(400.0, 0.0));
        polyArray.add(org.ktde.math.geom.types.doubletype.Linestring.createInstance(lineArray));
        this.poly = SegmentedPolygon.createInstance(polyArray);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Polyshrink.this.buildPolys();
                Polyshrink.this.repaint();
            }
        }.start();
        this.setVisible(true);
    }

    private void buildPolys() {
        this.outer = PolyShrinkAlgorithm.convertPoly(this.poly, true);
        this.side = null;
        int lineCount = this.poly.getLineCount();
        Object[][][] polyObject = new Object[lineCount][][];
        for (int l = 0; l < lineCount; ++l) {
            Linestring linestring = this.poly.getLinestringAt(l);
            int countPoints = linestring.getPointCount();
            polyObject[l] = new Object[countPoints][2];
            for (int p = 0; p < countPoints; ++p) {
                Point point = linestring.getPointAt(p);
                polyObject[l][p][0] = point.getX();
                polyObject[l][p][1] = point.getY();
            }
        }
    }

    protected void paintComponent(Graphics2D g) {
        BasicStroke bo = new BasicStroke(2.0f);
        BasicStroke bs = new BasicStroke(4.0f);
        BasicStroke bb = new BasicStroke(6.0f);
        int lineCount = this.poly.getLineCount();
        for (int l = 0; l < lineCount; ++l) {
            g.setColor(this.colors.get(l % this.colors.size()));
            if (this.outer != null) {
                g.setStroke(bo);
                if (this.outer.getLineCount() <= l) {
                    System.err.println("too few outers");
                } else {
                    this.drawLine(g, this.outer.getLinestringAt(l), false);
                }
            }
            if (this.bounds != null) {
                g.setStroke(bb);
                if (this.bounds.getLineCount() <= l) {
                    System.err.println("too few bounds");
                } else {
                    this.drawLine(g, this.bounds.getLinestringAt(l), false);
                }
            }
            if (this.side == null) continue;
            g.setStroke(bs);
            if (this.side.getLineCount() <= l) {
                System.err.println("too few sides");
                continue;
            }
            this.drawLine(g, this.side.getLinestringAt(l), false);
        }
        if (this.net != null) {
            g.setColor(Color.WHITE);
            g.setStroke(bo);
            for (Tupel<Point<Double>, Point<Double>> line : this.net) {
                g.drawLine((int)this.transformX(line.getElement1().getX()), (int)this.transformY(line.getElement1().getY()), (int)this.transformX(line.getElement2().getX()), (int)this.transformY(line.getElement2().getY()));
            }
        }
    }

    private void drawLine(Graphics2D g, Linestring<Double> linestring, boolean drawPoints) {
        int pointCount = linestring.getPointCount();
        Point<Double> lastPoint = linestring.getPointAt(0);
        for (int p = 1; p < pointCount; ++p) {
            Point<Double> point = linestring.getPointAt(p);
            g.drawLine((int)this.transformX(lastPoint.getX()), (int)this.transformY(lastPoint.getY()), (int)this.transformX(point.getX()), (int)this.transformY(point.getY()));
            if (drawPoints) {
                g.fillOval((int)this.transformX(point.getX()) - 3, (int)this.transformY(point.getY()) - 3, 6, 6);
            }
            lastPoint = point;
        }
    }

    public static void main(String[] args) {
        new Polyshrink();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.curpoint != null) {
            double cx = this.inverseTransformX(e.getX());
            double cy = this.inverseTransformY(e.getY());
            this.curpoint.setX(this.saveX + cx - this.startX);
            this.curpoint.setY(this.saveY + cy - this.startY);
            this.buildPolys();
        } else {
            double cx = e.getX();
            double cy = e.getY();
            this.offx = this.saveX + cx - this.startX;
            this.offy = this.saveY + cy - this.startY;
        }
        this.repaint(10L);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = this.inverseTransformX(e.getX());
        this.startY = this.inverseTransformY(e.getY());
        this.curpoint = null;
        int pointCount = this.poly.getPointCount();
        for (int p = 0; p < pointCount; ++p) {
            MutablePoint point = (MutablePoint)this.poly.getPointAt(p);
            double d1 = Math.sqrt(Math.pow(this.startX - (Double)point.getX(), 2.0) + Math.pow(this.startY - (Double)point.getY(), 2.0));
            if (!(d1 < 5.0 / this.FACTOR)) continue;
            this.curpoint = point;
            this.saveX = (Double)this.curpoint.getX();
            this.saveY = (Double)this.curpoint.getY();
            break;
        }
        if (this.curpoint == null) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.saveX = this.offx;
            this.saveY = this.offy;
        }
    }

    public void gotoCoords(double x, double y) {
        this.offx = -x * this.FACTOR;
        this.offy = y * this.FACTOR + (double)this.getHeight();
    }

    public double transformX(double x) {
        double tx = this.offx + x * this.FACTOR;
        return tx;
    }

    public double transformY(double y) {
        double ty = this.offy - y * this.FACTOR;
        return ty;
    }

    public double inverseTransformX(double x) {
        double tx = (x - this.offx) / this.FACTOR;
        return tx;
    }

    public double inverseTransformY(double y) {
        double ty = (this.offy - y) / this.FACTOR;
        return ty;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.curpoint = null;
    }

    public void actionPerformedAc(ActionEvent event) {
        Connection conn;
        try {
            Class.forName("org.postgresql.Driver");
            String host = "speedball.emanagers.lan";
            int port = 5432;
            String dbname = "gisimports_eu2008_2_de";
            String user = "postgres";
            String password = "damassa";
            conn = DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + dbname + "?user=" + user + "&password=" + password);
        }
        catch (Exception e) {
            conn = null;
            e.printStackTrace();
        }
        if (conn == null) {
            throw new IllegalStateException("DB not initialized");
        }
        try {
            String blocktable = "userdata_base.t_map_streetsegmentblock_eu2008_2_de_siegen";
            String sql = "SELECT id FROM " + blocktable + " ORDER BY id DESC";
            Statement statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            Hashtable timeHash = new Hashtable();
            ArrayList<Integer> timeKeys = new ArrayList<Integer>();
            while (resultSet.next()) {
                Set<String> keys = profile.keySet();
                Object[] keyArray = new String[keys.size()];
                int i = 0;
                for (String s : keys) {
                    keyArray[i++] = s;
                }
                Arrays.sort(keyArray);
                for (Object string : keyArray) {
                    profile.put((String)string, 0);
                }
                int blockid = resultSet.getInt("id");
                String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_siegen";
                sql = "SELECT COUNT(*) AS cnt FROM " + sidetable;
                sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
                statement = conn.createStatement();
                ResultSet resultSetCount = statement.executeQuery(sql);
                resultSetCount.next();
                int count = resultSetCount.getInt("cnt");
                resultSetCount.close();
                long t = System.currentTimeMillis();
                this.loadAndBuild(conn, blockid);
                long t2 = System.currentTimeMillis();
                if (!timeHash.containsKey(count)) {
                    timeHash.put(count, new ArrayList());
                    timeKeys.add(count);
                }
                ((List)timeHash.get(count)).add(t2 - t);
            }
            resultSet.close();
            Collections.sort(timeKeys);
            System.out.println("points,mean,min,max,dev,count");
            for (Integer count : timeKeys) {
                List list = (List)timeHash.get(count);
                double arithMean = ComputeStatistics.getMean(list);
                double dev = ComputeStatistics.getDeviation(list, arithMean);
                double min = ComputeStatistics.getMin(list);
                double max = ComputeStatistics.getMax(list);
                System.out.println(count + "," + (int)Math.round(arithMean) + "," + (int)Math.round(min) + "," + (int)Math.round(max) + "," + (int)Math.round(dev) + "," + list.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Connection conn;
        try {
            Class.forName("org.postgresql.Driver");
            String host = "speedball.emanagers.lan";
            int port = 5432;
            String dbname = "gisimports_eu2008_2_de";
            String user = "postgres";
            String password = "damassa";
            conn = DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + dbname + "?user=" + user + "&password=" + password);
        }
        catch (Exception e) {
            conn = null;
            e.printStackTrace();
        }
        if (conn == null) {
            throw new IllegalStateException("DB not initialized");
        }
        try {
            Statement statement = conn.createStatement();
            String blocktable = "userdata_base.t_map_streetsegmentblock_eu2008_2_de_siegen";
            String sql = "SELECT COUNT(*) AS cnt FROM " + blocktable;
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            int cnt = resultSet.getInt("cnt");
            resultSet.close();
            int fetchindex = (int)(Math.random() * (double)cnt);
            sql = "SELECT id FROM " + blocktable + " OFFSET " + fetchindex + " LIMIT 1";
            resultSet = statement.executeQuery(sql);
            resultSet.next();
            int blockid = resultSet.getInt("id");
            resultSet.close();
            String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_siegen";
            sql = "SELECT COUNT(*) AS cnt FROM " + sidetable;
            sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
            resultSet = statement.executeQuery(sql);
            resultSet.next();
            int count = resultSet.getInt("cnt");
            resultSet.close();
            System.out.print("Process Block id " + blockid + " with " + count + " segments ");
            long t = System.currentTimeMillis();
            this.loadAndBuild(conn, blockid);
            long t2 = System.currentTimeMillis();
            System.out.println("in " + (double)(t2 - t) / 1000.0 + " sec build");
            this.repaint(10L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAndBuild(Connection conn, int blockid) throws SQLException, ParseException {
        Statement statement = conn.createStatement();
        String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_siegen";
        String seggeomtable = "gis_base.t_segment_map_streetsegment_eu2008_2_de_siegen";
        String sql = "SELECT * FROM " + sidetable + " side";
        sql = sql + " JOIN " + seggeomtable + " seg ON side.id_map_streetsegment=seg.id";
        sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
        Hashtable<Integer, SideDef> hash = new Hashtable<Integer, SideDef>();
        ResultSet resultSet = statement.executeQuery(sql);
        WKBReader reader = new WKBReader();
        int startid = 0;
        int count = 0;
        while (resultSet.next()) {
            ++count;
            int sideid = resultSet.getInt("id");
            int nextid = resultSet.getInt("id_map_streetsegmentside_next");
            String geomhex = resultSet.getString("geom");
            String side = resultSet.getString("side");
            Geometry geom = reader.read(WKBReader.hexToBytes(geomhex));
            hash.put(sideid, new SideDef(sideid, nextid, geom, side.equalsIgnoreCase("l")));
            startid = sideid;
        }
        resultSet.close();
        ArrayList<org.ktde.math.geom.types.doubletype.Linestring> polyArray = new ArrayList<org.ktde.math.geom.types.doubletype.Linestring>();
        double left = Double.MAX_VALUE;
        double bottom = Double.MAX_VALUE;
        for (int p = 0; p < count; ++p) {
            SideDef curdef = (SideDef)hash.get(startid);
            ArrayList<MutablePoint> polypart = new ArrayList<MutablePoint>();
            LineString line = (LineString)curdef.getGeom();
            for (int i = 0; i < line.getNumPoints(); ++i) {
                com.vividsolutions.jts.geom.Point point = line.getPointN(i);
                polypart.add(new MutablePoint(point.getX(), point.getY()));
                left = Math.min(left, point.getX());
                bottom = Math.min(bottom, point.getY());
            }
            if (!curdef.isDirection()) {
                ArrayList polypartmirror = new ArrayList();
                for (int i = polypart.size() - 1; i >= 0; --i) {
                    polypartmirror.add(polypart.get(i));
                }
                polypart = polypartmirror;
            }
            org.ktde.math.geom.types.doubletype.Linestring linestring = org.ktde.math.geom.types.doubletype.Linestring.createInstance(polypart);
            polyArray.add(linestring);
            startid = curdef.getNextid();
        }
        this.poly = SegmentedPolygon.createInstance(polyArray);
        this.gotoCoords(left, bottom);
        this.buildPolys();
    }
}

