/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.WKBReader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.ktde.math.geom.algorithm.sand.AngleSectPoint;
import org.ktde.math.geom.algorithm.sand.SideDef;
import org.ktde.math.geom.algorithm.sand.polyshrink.ShrinkingPoint;
import org.ktde.util.datatypes.Tupel;

public class CopyOfPolyshrink
extends JFrame
implements MouseMotionListener,
MouseListener,
ActionListener {
    public final double FACTOR = 1.0;
    private static final long serialVersionUID = 6542538842747281621L;
    private List<List<ShrinkingPoint>> polys;
    private List<Color> colors;
    private ArrayList<Tupel<Double, Double>> poly;
    private double startX;
    private double startY;
    private Tupel<Double, Double> curpoint;
    private Double saveY;
    private Double saveX;
    private List<ShrinkingPoint> curWork;
    private List<ShrinkingPoint> outer;
    private List<ShrinkingPoint> side;
    private List<ShrinkingPoint> bounds;
    private double offx = 0.0;
    private double offy = 600.0;

    public CopyOfPolyshrink() {
        super("Polyshrink");
        JLabel canvas = new JLabel(" "){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                CopyOfPolyshrink.this.paintComponent((Graphics2D)g);
            }
        };
        this.getContentPane().add((Component)canvas, "Center");
        JButton button = new JButton("Test Streets");
        this.getContentPane().add((Component)button, "South");
        button.addActionListener(this);
        this.setSize(1000, 700);
        this.setDefaultCloseOperation(3);
        canvas.addMouseMotionListener(this);
        canvas.addMouseListener(this);
        this.colors = new ArrayList<Color>();
        this.colors.add(Color.BLACK);
        this.colors.add(Color.RED);
        this.colors.add(Color.GREEN);
        this.colors.add(Color.BLUE);
        this.colors.add(Color.MAGENTA);
        this.colors.add(Color.CYAN);
        this.colors.add(Color.YELLOW);
        this.poly = new ArrayList();
        this.poly.add(new Tupel<Double, Double>(40.0, 0.0));
        this.poly.add(new Tupel<Double, Double>(40.0, 10.0));
        this.poly.add(new Tupel<Double, Double>(80.0, 60.0));
        this.polys = new ArrayList<List<ShrinkingPoint>>();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CopyOfPolyshrink.this.buildPolys();
            }
        }.start();
        this.setVisible(true);
    }

    private void buildPolys() {
        int i;
        List<ShrinkingPoint> nextpoly;
        this.polys = new ArrayList<List<ShrinkingPoint>>();
        this.outer = this.convertPoly(this.poly);
        this.polys.add(this.outer);
        this.repaint(10L);
        double area = 0.0;
        for (int i2 = 1; i2 < this.poly.size() + 1; ++i2) {
            double x1 = this.poly.get(i2 - 1).getElement1();
            double y1 = this.poly.get(i2 - 1).getElement2();
            double x2 = this.poly.get(i2 % this.poly.size()).getElement1();
            double y2 = this.poly.get(i2 % this.poly.size()).getElement2();
            double change = x1 * y2 - x2 * y1;
            area += change;
        }
        if (area < 0.0) {
            return;
        }
        List<ShrinkingPoint> curpoly = nextpoly = this.shrink(this.outer, 0.001, true);
        nextpoly = this.shrink(curpoly, 1.999, false);
        this.polys.add(nextpoly);
        curpoly = nextpoly;
        for (i = 0; i < 6; ++i) {
            nextpoly = this.shrink(curpoly, 2.0, false);
            this.polys.add(nextpoly);
            curpoly = nextpoly;
            if (i != 2) continue;
            this.side = curpoly;
        }
        this.bounds = this.shrink(curpoly, 1.0, false);
        for (i = 0; i < this.bounds.size(); ++i) {
            ShrinkingPoint shrinkingPoint = this.bounds.get(i);
            double fac = shrinkingPoint.getFac();
            if (!(fac < 10.0)) continue;
            if (fac > 4.0) {
                this.side.get(i).setFac(fac - 2.0);
                continue;
            }
            this.side.get(i).setFac(fac / 2.0);
        }
    }

    private void addPoints(List<ShrinkingPoint> result, Tupel<Double, Double> point, Tupel<Double, Double> prev, Tupel<Double, Double> next) {
        double angle2;
        double x = point.getElement1();
        double y = point.getElement2();
        double x1 = prev.getElement1();
        double y1 = prev.getElement2();
        double x2 = next.getElement1();
        double y2 = next.getElement2();
        double deltax1 = x1 - x;
        double deltay1 = y1 - y;
        double deltax2 = x2 - x;
        double deltay2 = y2 - y;
        double angle1 = Math.atan2(deltay1, deltax1);
        double angle = CopyOfPolyshrink.normalizeAngle(angle1 - (angle2 = Math.atan2(deltay2, deltax2)), false);
        if (angle > Math.PI) {
            int countPoints = 1;
            countPoints = angle < 3.9269908169872414 ? 3 : (angle < 4.71238898038469 ? 4 : (angle < 5.497787143782138 ? 6 : (angle < Math.PI * 2 ? 8 : 10)));
            double anglestep = (angle - Math.PI) / (double)(countPoints - 1);
            double curAngle = angle1 - 1.5707963267948966;
            for (int i = 0; i < countPoints; ++i) {
                ShrinkingPoint curpoint = new ShrinkingPoint(point.getElement1(), point.getElement2(), new AngleSectPoint(1.0, curAngle));
                result.add(curpoint);
                curAngle = CopyOfPolyshrink.normalizeAngle(curAngle - anglestep);
            }
        } else {
            while (angle1 < angle2) {
                angle1 += Math.PI * 2;
            }
            double c = 1.0 / Math.sin(angle / 2.0);
            double a = CopyOfPolyshrink.normalizeAngle((angle1 + angle2) / 2.0);
            ShrinkingPoint curpoint = new ShrinkingPoint(point.getElement1(), point.getElement2(), new AngleSectPoint(c, a));
            result.add(curpoint);
        }
    }

    private void setMax(ShrinkingPoint p1, ShrinkingPoint p2) {
        double angleb;
        double l = Math.sqrt(Math.pow((Double)p1.getX() - (Double)p2.getX(), 2.0) + Math.pow((Double)p1.getY() - (Double)p2.getY(), 2.0));
        if (l == 0.0) {
            return;
        }
        double angle = CopyOfPolyshrink.normalizeAngle(Math.atan2((Double)p2.getY() - (Double)p1.getY(), (Double)p2.getX() - (Double)p1.getX()));
        double anglea = CopyOfPolyshrink.normalizeAngle(((AngleSectPoint)p1.getFunction()).getAngle() - angle);
        if (anglea > 1.5707963267948966) {
            anglea = 1.5707963267948966;
        }
        if ((angleb = CopyOfPolyshrink.normalizeAngle(Math.PI - (((AngleSectPoint)p2.getFunction()).getAngle() - angle))) > 1.5707963267948966) {
            angleb = 1.5707963267948966;
        }
        if (anglea == 1.5707963267948966 && angleb == 1.5707963267948966) {
            return;
        }
        double ta = Math.tan(anglea);
        double tb = Math.tan(angleb);
        double j = l * tb / (ta + tb);
        double s = j * ta;
        double h = s / Math.sin(angleb);
        double g = s / Math.sin(anglea);
        double he = this.FACTOR * h / (l * 7.0);
        double ge = this.FACTOR * g / (l * 7.0);
        ((AngleSectPoint)p1.getFunction()).setMax(g - ge);
        ((AngleSectPoint)p2.getFunction()).setMax(h - he);
    }

    private static double normalizeAngle(double angle) {
        return CopyOfPolyshrink.normalizeAngle(angle, true);
    }

    private static double normalizeAngle(double angle, boolean boundZero) {
        while (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle == 0.0 && !boundZero) {
            angle = Math.PI * 2;
        }
        return angle;
    }

    private List<ShrinkingPoint> convertPoly(ArrayList<Tupel<Double, Double>> poly) {
        ArrayList<ShrinkingPoint> result = new ArrayList<ShrinkingPoint>();
        Tupel<Double, Double> last = poly.get(poly.size() - 2);
        Tupel<Double, Double> cur = poly.get(poly.size() - 1);
        for (Tupel<Double, Double> next : poly) {
            this.addPoints(result, cur, last, next);
            last = cur;
            cur = next;
        }
        if (result.size() > 2) {
            ShrinkingPoint p1 = (ShrinkingPoint)result.get(result.size() - 1);
            for (ShrinkingPoint p2 : result) {
                this.setMax(p1, p2);
                p1 = p2;
            }
        }
        return result;
    }

    private List<ShrinkingPoint> shrink(List<ShrinkingPoint> poly, double fac, boolean ignoreIntersect) {
        ArrayList<ShrinkingPoint> result = new ArrayList<ShrinkingPoint>();
        for (ShrinkingPoint shrinkingPoint : poly) {
            result.add(shrinkingPoint);
        }
        this.curWork = result;
        for (int i = 0; i < result.size(); ++i) {
            ShrinkingPoint cur = (ShrinkingPoint)result.get(i);
            ShrinkingPoint shrinked = cur.getShrinkedPoint(fac);
            boolean intersect = !ignoreIntersect && CopyOfPolyshrink.checkComplex(result, shrinked, i);
            result.set(i, shrinked);
            this.repaint(10L);
            if (!intersect) continue;
            result.set(i, cur);
            this.repaint(10L);
        }
        this.curWork = null;
        return result;
    }

    public static boolean checkComplex(List<ShrinkingPoint> poly, ShrinkingPoint replace, int ati) {
        int j;
        int i = 0;
        for (j = i + 2; j < poly.size() - 1; ++j) {
            if (!CopyOfPolyshrink.intersect(poly, replace, ati, i, j)) continue;
            return true;
        }
        for (i = 1; i < poly.size(); ++i) {
            for (j = i + 2; j < poly.size(); ++j) {
                if (!CopyOfPolyshrink.intersect(poly, replace, ati, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean intersect(List<ShrinkingPoint> poly, ShrinkingPoint replace, int ati, int i, int j) {
        int s1 = i > 0 ? i - 1 : poly.size() - 1;
        int s2 = j > 0 ? j - 1 : poly.size() - 1;
        ShrinkingPoint ps1 = ati == s1 ? replace : poly.get(s1);
        ShrinkingPoint ps2 = ati == s2 ? replace : poly.get(s2);
        ShrinkingPoint pi1 = ati == i ? replace : poly.get(i);
        ShrinkingPoint pi2 = ati == j ? replace : poly.get(j);
        return CopyOfPolyshrink.ccw((Double)ps1.getX(), (Double)ps1.getY(), (Double)pi1.getX(), (Double)pi1.getY(), (Double)ps2.getX(), (Double)ps2.getY()) != CopyOfPolyshrink.ccw((Double)ps1.getX(), (Double)ps1.getY(), (Double)pi1.getX(), (Double)pi1.getY(), (Double)pi2.getX(), (Double)pi2.getY()) && CopyOfPolyshrink.ccw((Double)ps2.getX(), (Double)ps2.getY(), (Double)pi2.getX(), (Double)pi2.getY(), (Double)ps1.getX(), (Double)ps1.getY()) != CopyOfPolyshrink.ccw((Double)ps2.getX(), (Double)ps2.getY(), (Double)pi2.getX(), (Double)pi2.getY(), (Double)pi1.getX(), (Double)pi1.getY());
    }

    public static boolean ccw(double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        double dy1 = p2y - p1y;
        double dx2 = p3x - p2x;
        double dy2 = p3y - p2y;
        double dx1 = p2x - p1x;
        return dy1 * dx2 < dy2 * dx1;
    }

    protected void paintComponent(Graphics2D g) {
        if (this.FACTOR < 2.0) {
            BasicStroke bf = new BasicStroke(2.0f);
            if (this.outer != null) {
                g.setStroke(bf);
                g.setColor(Color.black);
                this.drawPoly(g, this.outer, false);
            }
            if (this.side != null) {
                g.setStroke(bf);
                g.setColor(Color.BLUE);
                this.drawPoly(g, this.side, false);
            }
            if (this.bounds != null) {
                g.setStroke(bf);
                g.setColor(Color.RED);
                this.drawPoly(g, this.bounds, false);
            }
        } else {
            BasicStroke bf = new BasicStroke(4.0f);
            if (this.outer != null) {
                g.setStroke(bf);
                g.setColor(Color.black);
                this.drawPoly(g, this.outer, true);
            }
            if (this.side != null) {
                g.setStroke(bf);
                g.setColor(Color.BLUE);
                this.drawPoly(g, this.side, true);
            }
            if (this.bounds != null) {
                g.setStroke(bf);
                g.setColor(Color.RED);
                this.drawPoly(g, this.bounds, true);
            }
            BasicStroke b = new BasicStroke(1.0f);
            g.setStroke(b);
            for (int i = 0; i < this.polys.size(); ++i) {
                g.setColor(this.colors.get(i % this.colors.size()));
                List<ShrinkingPoint> curpoly = this.polys.get(i);
                this.drawPoly(g, curpoly, false);
            }
            if (this.curWork != null) {
                g.setStroke(b);
                g.setColor(this.colors.get(this.polys.size() % this.colors.size()));
                this.drawPoly(g, this.curWork, false);
            }
        }
    }

    private void drawPoly(Graphics2D g, List<ShrinkingPoint> poly, boolean drawPoints) {
        ShrinkingPoint lastPoint = poly.get(poly.size() - 1);
        for (ShrinkingPoint point : poly) {
            g.drawLine((int)this.transformX((Double)lastPoint.getX()), (int)this.transformY((Double)lastPoint.getY()), (int)this.transformX((Double)point.getX()), (int)this.transformY((Double)point.getY()));
            if (drawPoints) {
                g.fillOval((int)this.transformX((Double)point.getX()) - 3, (int)this.transformY((Double)point.getY()) - 3, 6, 6);
            }
            lastPoint = point;
        }
    }

    public static boolean intersects(ShrinkingPoint p11, ShrinkingPoint p12, ShrinkingPoint p21, ShrinkingPoint p22) {
        boolean result = false;
        Line2D.Double l1 = new Line2D.Double((Double)p11.getX(), (Double)p11.getY(), (Double)p12.getX(), (Double)p12.getY());
        Line2D.Double l2 = new Line2D.Double((Double)p21.getX(), (Double)p21.getY(), (Double)p22.getX(), (Double)p22.getY());
        result = l1.intersectsLine(l2);
        return result;
    }

    public static void main(String[] args) {
        new CopyOfPolyshrink();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.curpoint != null) {
            double cx = this.inverseTransformX(e.getX());
            double cy = this.inverseTransformY(e.getY());
            this.curpoint.setElement1(this.saveX + cx - this.startX);
            this.curpoint.setElement2(this.saveY + cy - this.startY);
            this.buildPolys();
        } else {
            double cx = e.getX();
            double cy = e.getY();
            this.offx = this.saveX + cx - this.startX;
            this.offy = this.saveY + cy - this.startY;
        }
        this.repaint(10L);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = this.inverseTransformX(e.getX());
        this.startY = this.inverseTransformY(e.getY());
        this.curpoint = null;
        for (Tupel<Double, Double> point : this.poly) {
            double d1 = Math.sqrt(Math.pow(this.startX - point.getElement1(), 2.0) + Math.pow(this.startY - point.getElement2(), 2.0));
            if (!(d1 < 3.0)) continue;
            this.curpoint = point;
            this.saveX = this.curpoint.getElement1();
            this.saveY = this.curpoint.getElement2();
            break;
        }
        if (this.curpoint == null) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.saveX = this.offx;
            this.saveY = this.offy;
        }
    }

    public void gotoCoords(double x, double y) {
        this.offx = -x * this.FACTOR;
        this.offy = y * this.FACTOR + 600.0;
    }

    public double transformX(double x) {
        double tx = this.offx + x * this.FACTOR;
        return tx;
    }

    public double transformY(double y) {
        double ty = this.offy - y * this.FACTOR;
        return ty;
    }

    public double inverseTransformX(double x) {
        double tx = (x - this.offx) / this.FACTOR;
        return tx;
    }

    public double inverseTransformY(double y) {
        double ty = (this.offy - y) / this.FACTOR;
        return ty;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.curpoint = null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Connection conn;
        try {
            Class.forName("org.postgresql.Driver");
            String host = "speedball.emanagers.lan";
            int port = 5432;
            String dbname = "gisimports_eu2008_2_de";
            String user = "postgres";
            String password = "damassa";
            conn = DriverManager.getConnection("jdbc:postgresql://" + host + ":" + port + "/" + dbname + "?user=" + user + "&password=" + password);
        }
        catch (Exception e) {
            conn = null;
            e.printStackTrace();
        }
        if (conn == null) {
            throw new IllegalStateException("DB not initialized");
        }
        try {
            Statement statement = conn.createStatement();
            String blocktable = "userdata_base.t_map_streetsegmentblock_eu2008_2_de_landpass";
            String sql = "SELECT COUNT(*) AS cnt FROM " + blocktable;
            ResultSet resultSet = statement.executeQuery(sql);
            resultSet.next();
            int cnt = resultSet.getInt("cnt");
            resultSet.close();
            int fetchindex = (int)(Math.random() * (double)cnt);
            sql = "SELECT id FROM " + blocktable + " OFFSET " + fetchindex + " LIMIT 1";
            resultSet = statement.executeQuery(sql);
            resultSet.next();
            int blockid = resultSet.getInt("id");
            resultSet.close();
            String sidetable = "userdata_base.t_map_streetsegmentside_eu2008_2_de_landpass";
            String seggeomtable = "gis_base.t_segment_map_streetsegment_eu2008_2_de_landpass";
            sql = "SELECT * FROM " + sidetable + " side";
            sql = sql + " JOIN " + seggeomtable + " seg ON side.id_map_streetsegment=seg.id";
            sql = sql + " WHERE id_map_streetsegmentblock=" + blockid;
            Hashtable<Integer, SideDef> hash = new Hashtable<Integer, SideDef>();
            resultSet = statement.executeQuery(sql);
            WKBReader reader = new WKBReader();
            int startid = 0;
            int count = 0;
            while (resultSet.next()) {
                ++count;
                int sideid = resultSet.getInt("id");
                int nextid = resultSet.getInt("id_map_streetsegmentside_next");
                String geomhex = resultSet.getString("geom");
                String side = resultSet.getString("side");
                Geometry geom = reader.read(WKBReader.hexToBytes(geomhex));
                hash.put(sideid, new SideDef(sideid, nextid, geom, side.equalsIgnoreCase("l")));
                startid = sideid;
            }
            System.out.print("Process Block index " + fetchindex + " with " + count + " segments ");
            resultSet.close();
            long t = System.currentTimeMillis();
            this.poly = new ArrayList();
            double left = Double.MAX_VALUE;
            double bottom = Double.MAX_VALUE;
            for (int p = 0; p < count; ++p) {
                SideDef curdef = (SideDef)hash.get(startid);
                ArrayList<Tupel<Double, Double>> polypart = p == 0 ? this.poly : new ArrayList<Tupel<Double, Double>>();
                LineString line = (LineString)curdef.getGeom();
                for (int i = 0; i < line.getNumPoints(); ++i) {
                    Point point = line.getPointN(i);
                    polypart.add(new Tupel<Double, Double>(point.getX(), point.getY()));
                    left = Math.min(left, point.getX());
                    bottom = Math.min(bottom, point.getY());
                }
                if (!curdef.isDirection()) {
                    ArrayList polypartmirror = new ArrayList();
                    for (int i = polypart.size() - 1; i >= 0; --i) {
                        polypartmirror.add(polypart.get(i));
                    }
                    if (p == 0) {
                        this.poly = polypartmirror;
                    } else {
                        polypart = polypartmirror;
                    }
                }
                if (p > 0) {
                    if (((Tupel)polypart.get(0)).equals(this.poly.get(this.poly.size() - 1))) {
                        polypart.remove(0);
                    }
                    this.poly.addAll(polypart);
                }
                startid = curdef.getNextid();
            }
            if (this.poly.get(0).equals(this.poly.get(this.poly.size() - 1))) {
                this.poly.remove(0);
            }
            this.gotoCoords(left, bottom);
            long t2 = System.currentTimeMillis();
            this.buildPolys();
            long t3 = System.currentTimeMillis();
            System.out.println("in " + (double)(t2 - t) / 1000.0 + " sec parse, " + (double)(t3 - t2) / 1000.0 + " sec build");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

