/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math.geom.algorithm.sand;

import org.ktde.math.geom.algorithm.sand.PointFunction;
import org.ktde.util.datatypes.Tupel;

public class AngleSectPoint
implements PointFunction {
    private double max;
    private double corr;
    private double angle;

    public AngleSectPoint(double max, double corr, double angle) {
        this.max = max;
        this.corr = corr;
        this.angle = angle;
    }

    public AngleSectPoint(double corr, double angle) {
        this(Double.MAX_VALUE, corr, angle);
    }

    @Override
    public double checkFac(double fac) {
        double len = fac * this.corr;
        if (len > this.max) {
            fac = this.max / this.corr;
        }
        return fac;
    }

    @Override
    public Tupel<Double, Double> getDelta(double fac) {
        double len = fac * this.corr;
        if (len > this.max) {
            len = this.max;
        }
        double x = Math.cos(this.angle) * len;
        double y = Math.sin(this.angle) * len;
        return new Tupel<Double, Double>(x, y);
    }

    public void setMax(double max) {
        this.max = Math.min(this.max, max);
    }

    public double getAngle() {
        return this.angle;
    }
}

