/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.math;

import java.util.List;

public class ComputeStatistics {
    public static <T extends Number> double getMean(List<T> list) {
        int size = list.size();
        if (size > 0) {
            double sum = 0.0;
            for (Number number : list) {
                sum += number.doubleValue();
            }
            return sum / (double)size;
        }
        return 0.0;
    }

    public static <T extends Number> double getDeviation(List<T> list, double arithMean) {
        int size = list.size();
        if (size > 1) {
            double sum = 0.0;
            for (Number number : list) {
                sum += Math.pow(number.doubleValue() - arithMean, 2.0);
            }
            return Math.sqrt(sum / (double)(size - 1));
        }
        return Double.POSITIVE_INFINITY;
    }

    public static <T extends Number> double getMin(List<T> list) {
        double min = 0.0;
        for (Number number : list) {
            min = Math.min(number.doubleValue(), min);
        }
        return min;
    }

    public static <T extends Number> double getMax(List<T> list) {
        double max = 0.0;
        for (Number number : list) {
            max = Math.max(number.doubleValue(), max);
        }
        return max;
    }
}

