/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.transaction;

import java.lang.reflect.Method;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.ktde.ee.transaction.ThreadLocalContext;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;

public class SessionOpenInterceptor
implements MethodBeforeAdvice,
AfterReturningAdvice,
ThrowsAdvice {
    private SessionFactory sessionFactory;

    public SessionOpenInterceptor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void before(Method method, Object[] args, Object object) throws Throwable {
        Session session = ThreadLocalContext.getCurrentSession();
        if (session == null) {
            session = this.sessionFactory.openSession();
            ThreadLocalContext.setCurrentSession(session);
            Transaction transaction = session.beginTransaction();
            ThreadLocalContext.setCurrentTransaction(transaction);
        }
    }

    @Override
    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        Session session = ThreadLocalContext.getCurrentSession();
        if (session != null) {
            Transaction transaction = ThreadLocalContext.getCurrentTransaction();
            transaction.commit();
            session.close();
            ThreadLocalContext.removeCurrentSession();
            ThreadLocalContext.removeCurrentTransaction();
        }
    }

    public void afterThrowing(Method method, Object[] args, Object target, Throwable ex) {
        Session session = ThreadLocalContext.getCurrentSession();
        if (session != null) {
            Transaction transaction = ThreadLocalContext.getCurrentTransaction();
            transaction.rollback();
            session.close();
            ThreadLocalContext.removeCurrentSession();
            ThreadLocalContext.removeCurrentTransaction();
        }
    }
}

