/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.transaction;

import java.lang.reflect.Method;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.impl.SessionImpl;
import org.ktde.util.ContextLocal;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;

public class PerformTransacted
implements MethodBeforeAdvice,
AfterReturningAdvice,
ThrowsAdvice {
    private static ContextLocal<Integer> callDepth = new ContextLocal();
    private static ContextLocal<Session> session = new ContextLocal();
    private static ContextLocal<Transaction> transaction = new ContextLocal();
    private boolean rollbackOnError = true;
    private SessionFactory sessionFactory;

    public boolean isRollbackOnError() {
        return this.rollbackOnError;
    }

    public void setRollbackOnError(boolean rollbackOnError) {
        this.rollbackOnError = rollbackOnError;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void before(Method method, Object[] args, Object object) throws Throwable {
        Integer depth = callDepth.get();
        if (depth == null || depth == 0) {
            this.openSession();
            PerformTransacted.txBegin();
            depth = 0;
        }
        Integer n = depth;
        Integer n2 = depth = Integer.valueOf(depth + 1);
        callDepth.set(depth);
    }

    public void openSession() {
        Session openSession = session.get();
        if (openSession == null) {
            openSession = this.sessionFactory.openSession();
            session.set(openSession);
        }
    }

    public static void txBegin() {
        Session openSession = session.get();
        Transaction openTransaction = openSession.beginTransaction();
        transaction.set(openTransaction);
    }

    public static void txCommit() {
        Session openSession = session.get();
        openSession.flush();
        transaction.get().commit();
        transaction.remove();
    }

    public static void txRollback() {
        Transaction transaction = PerformTransacted.transaction.get();
        transaction.rollback();
        PerformTransacted.transaction.remove();
    }

    public static void closeSession() {
        Transaction transaction = PerformTransacted.transaction.get();
        if (transaction != null) {
            PerformTransacted.txRollback();
        }
        session.get().close();
        session.remove();
    }

    @Override
    public void afterReturning(Object returnValue, Method method, Object[] args, Object object) throws Throwable {
        Integer depth = callDepth.get();
        if (depth != null) {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            if (depth == 0) {
                PerformTransacted.txCommit();
                PerformTransacted.closeSession();
                PerformTransacted.removeContext(Thread.currentThread());
            }
            callDepth.set(depth);
        }
    }

    public void afterThrowing(Method method, Object[] args, Object target, Throwable throwable) {
        Integer depth = callDepth.get();
        if (depth != null) {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            if (depth == 0) {
                if (this.rollbackOnError) {
                    PerformTransacted.txRollback();
                    PerformTransacted.closeSession();
                } else {
                    PerformTransacted.txCommit();
                    PerformTransacted.closeSession();
                }
                PerformTransacted.removeContext(Thread.currentThread());
            }
            callDepth.set(depth);
        }
    }

    public static void removeContext(Object context) {
        callDepth.removeContextObject(context);
        session.removeContextObject(context);
        transaction.removeContextObject(context);
    }

    public static void setContext(Object context) {
        callDepth.setContextObject(context);
        session.setContextObject(context);
        transaction.setContextObject(context);
    }

    public static Session getSession() {
        return session.get();
    }

    public static void evictObjects(Collection<Object> objects) {
        Session session = PerformTransacted.session.get();
        for (Object object : objects) {
            session.evict(object);
        }
    }

    public static void loadObjects(Collection<Object> objects) {
        Session session = PerformTransacted.session.get();
        for (Object object : objects) {
            session.get(object.getClass(), session.getIdentifier(object));
        }
    }

    public static void clearPendings() {
        Session session = PerformTransacted.session.get();
        ((SessionImpl)session).getActionQueue().clear();
    }
}

