/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.spring;

import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.ktde.ee.spring.InitializingEntityInterceptor;
import org.springframework.orm.hibernate3.annotation.AnnotationSessionFactoryBean;

public class SettingExtendibleSessionFactoryBean
extends AnnotationSessionFactoryBean {
    private Interceptor interceptor;
    private static Map<SessionFactory, Properties> externalizedPropsMap = new WeakHashMap<SessionFactory, Properties>();

    public static Properties getPropertiesForSessionFactory(SessionFactory rawSf) {
        return externalizedPropsMap.get(rawSf);
    }

    @Override
    protected synchronized SessionFactory wrapSessionFactoryIfNecessary(SessionFactory rawSf) {
        externalizedPropsMap.put(rawSf, this.getHibernateProperties());
        return rawSf;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.interceptor instanceof InitializingEntityInterceptor) {
            ((InitializingEntityInterceptor)this.interceptor).initialize();
        }
    }

    @Override
    public void setEntityInterceptor(Interceptor entityInterceptor) {
        super.setEntityInterceptor(entityInterceptor);
        this.interceptor = entityInterceptor;
    }
}

