/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi.hessian;

import com.caucho.hessian.client.AbstractHessianConnection;
import com.caucho.hessian.client.HessianConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.ktde.ee.rmi.hessian.RetryException;

public class HessianURLConnection
extends AbstractHessianConnection {
    private static final int[] RETRY_HTTP_CODES = new int[]{503};
    private URL _url;
    private URLConnection _conn;
    private int _statusCode;
    private String _statusMessage;
    private Properties properties;

    public HessianURLConnection(Properties properties, URL url, URLConnection conn) {
        this._url = url;
        this._conn = conn;
        this.properties = properties;
    }

    @Override
    public void addHeader(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._conn.getOutputStream();
    }

    @Override
    public void sendRequest() throws IOException, RetryException {
        if (this._conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)this._conn;
            this._statusCode = 500;
            try {
                this._statusCode = httpConn.getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parseResponseHeaders(httpConn);
            InputStream is = null;
            if (this._statusCode != 200) {
                StringBuffer sb = new StringBuffer();
                try {
                    int ch;
                    is = httpConn.getInputStream();
                    if (is != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                        is.close();
                    }
                    if ((is = httpConn.getErrorStream()) != null) {
                        while ((ch = is.read()) >= 0) {
                            sb.append((char)ch);
                        }
                    }
                    this._statusMessage = sb.toString();
                }
                catch (FileNotFoundException e) {
                    throw new HessianConnectionException("HessianProxy cannot connect to '" + this._url, e);
                }
                catch (IOException e) {
                    String message = is == null ? this._statusCode + ": " + e : this._statusCode + ": " + sb;
                    if (ArrayUtils.contains(RETRY_HTTP_CODES, this._statusCode)) {
                        throw new RetryException(message, e);
                    }
                    throw new HessianConnectionException(message, e);
                }
                if (is != null) {
                    is.close();
                }
                throw new HessianConnectionException(this._statusCode + ": " + sb.toString());
            }
        }
    }

    protected void parseResponseHeaders(HttpURLConnection conn) throws IOException {
        Map<String, List<String>> headers = conn.getHeaderFields();
        List<String> values = headers.get("Set-Cookie");
        if (values != null && !values.isEmpty()) {
            Hashtable<String, String> cookieValues = (Hashtable<String, String>)this.properties.get("");
            if (cookieValues == null) {
                cookieValues = new Hashtable<String, String>();
                this.properties.put("cookies", cookieValues);
            }
            for (String cookie : values) {
                int index = cookie.indexOf(";");
                if (index >= 0) {
                    cookie = cookie.substring(0, index);
                }
                if ((index = cookie.indexOf("=")) < 0) continue;
                String cookieName = cookie.substring(0, index);
                String cookieValue = cookie.substring(index + 1, cookie.length());
                cookieValues.put(cookieName, cookieValue);
            }
        }
    }

    @Override
    public int getStatusCode() {
        return this._statusCode;
    }

    @Override
    public String getStatusMessage() {
        return this._statusMessage;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this._conn.getInputStream();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        URLConnection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            try {
                IOUtils.closeQuietly(conn.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                IOUtils.closeQuietly(conn.getOutputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                IOUtils.closeQuietly(((HttpURLConnection)conn).getErrorStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }
}

