/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Properties;
import org.ktde.ee.rmi.CommType;
import org.ktde.ee.rmi.ServiceInvocationHandler;
import org.ktde.util.ExceptionHandlerFactory;

public class ServerStub {
    private String url;
    private Object context;
    private CommType commType;
    private ClassLoader loader;
    private Hashtable<Class<?>, Object> services;
    private Properties properties;
    private ExceptionHandlerFactory exceptionHandlerFactory;

    public ServerStub(String url, CommType commType, ExceptionHandlerFactory exceptionHandlerFactory, Object context, Properties properties) {
        this.url = url;
        this.context = context;
        this.commType = commType;
        this.services = new Hashtable();
        this.loader = Thread.currentThread().getContextClassLoader();
        this.properties = properties;
        this.exceptionHandlerFactory = exceptionHandlerFactory;
    }

    protected CommType getCommType() {
        return this.commType;
    }

    protected String getUrlExtension(Class<?> c, CommType commType) {
        return "";
    }

    public synchronized <T> T getBusinessInterface(Class<T> c) {
        Object service = this.services.get(c);
        if (service == null) {
            ServiceInvocationHandler handler = new ServiceInvocationHandler(this.commType.createInstance(this, c, this.url + this.getUrlExtension(c, this.commType)), this.exceptionHandlerFactory, this.context);
            service = Proxy.newProxyInstance(this.loader, new Class[]{c}, (InvocationHandler)handler);
            this.services.put(c, service);
        }
        return (T)service;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

