/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.ktde.ee.layer.MappingFactory;
import org.ktde.ee.rmi.CacheableDto;
import org.ktde.ee.rmi.SequencingDto;
import org.ktde.model.CacheableModel;
import org.ktde.model.SequencingModel;
import org.ktde.util.ExceptionHandler;
import org.ktde.util.ExceptionHandlerFactory;
import org.ktde.util.cache.TwoLevelCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelManagerServiceInvocationHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelManagerServiceInvocationHandler.class);
    private final WeakHashMap<Method, Method> methodMap;
    private TwoLevelCache<Class<?>, Long, CacheableModel> cache;
    private final Object delegate;
    private final Object context;
    private MappingFactory mappingFactory;
    private ExceptionHandlerFactory exceptionHandlerFactory;

    public ModelManagerServiceInvocationHandler(TwoLevelCache<Class<?>, Long, CacheableModel> cache, Object delegate, MappingFactory mappingFactory, ExceptionHandlerFactory exceptionHandlerFactory, Object context) {
        this.context = context;
        this.cache = cache;
        this.delegate = delegate;
        this.methodMap = new WeakHashMap();
        this.mappingFactory = mappingFactory;
        this.exceptionHandlerFactory = exceptionHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method delegateMethod;
        WeakHashMap<Method, Method> weakHashMap = this.methodMap;
        synchronized (weakHashMap) {
            delegateMethod = this.methodMap.get(method);
            if (delegateMethod == null) {
                delegateMethod = this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
            }
        }
        LOGGER.trace("called " + method.getName());
        Object result = null;
        while (true) {
            try {
                result = delegateMethod.invoke(this.delegate, args);
            }
            catch (Throwable e) {
                while (true) {
                    if (e instanceof UndeclaredThrowableException) {
                        e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                        continue;
                    }
                    if (!(e instanceof InvocationTargetException)) break;
                    e = ((InvocationTargetException)e).getTargetException();
                }
                ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlerFactory.getInstance(e.getClass());
                if (handler != null) continue;
                throw e;
                if (handler.handle(e, this.context)) continue;
            }
            break;
        }
        TwoLevelCache<Class<?>, Long, CacheableModel> twoLevelCache = this.cache;
        synchronized (twoLevelCache) {
            this.syncCached(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCached(Object object) {
        if (object != null) {
            if (object instanceof CacheableDto) {
                long id = ((CacheableDto)object).getId();
                Class<?> dtoClazz = object.getClass();
                Class modelClazz = this.mappingFactory.getTargetClass(dtoClazz, object);
                Collection<Class<?>> parentClasses = this.mappingFactory.getParentClasses(dtoClazz, object);
                CacheableModel knownInstance = this.cache.getInstance(modelClazz, id);
                if (knownInstance == null) {
                    knownInstance = (CacheableModel)this.mappingFactory.createInstance(dtoClazz, object);
                    knownInstance.setId(id);
                    if (object instanceof SequencingDto) {
                        ((SequencingModel)((Object)knownInstance)).setUpdateSequence(-1L);
                    }
                    this.cache.setInstance(modelClazz, id, knownInstance);
                    if (parentClasses != null) {
                        for (Class<?> clazz1 : parentClasses) {
                            this.cache.setInstance(clazz1, id, knownInstance);
                        }
                    }
                }
                if (object instanceof SequencingDto) {
                    long newSeq = ((SequencingDto)object).getUpdateSequence();
                    if (newSeq > ((SequencingModel)((Object)knownInstance)).getUpdateSequence()) {
                        boolean optFailed = false;
                        if (((SequencingModel)((Object)knownInstance)).isDirty()) {
                            if (!((SequencingDto)object).isForcedUpdate()) {
                                optFailed = true;
                            } else {
                                ((SequencingModel)((Object)knownInstance)).setDirty(false);
                            }
                        } else {
                            knownInstance.deferLoadedValues();
                        }
                        this.mappingFactory.fillObject(dtoClazz, object, knownInstance);
                        ((SequencingModel)((Object)knownInstance)).setUpdateSequence(newSeq);
                        if (optFailed) {
                            throw new IllegalStateException("External change to entity");
                        }
                    } else {
                        CacheableModel cacheableModel = knownInstance;
                        synchronized (cacheableModel) {
                            knownInstance.setOnlyDeferred(true);
                            this.mappingFactory.fillObject(dtoClazz, object, knownInstance);
                            knownInstance.setOnlyDeferred(false);
                        }
                        this.mappingFactory.fillObject(dtoClazz, object, knownInstance);
                    }
                } else {
                    this.mappingFactory.fillObject(dtoClazz, object, knownInstance);
                }
            } else if (object instanceof Iterable) {
                Iterator iter = ((Iterable)object).iterator();
                while (iter.hasNext()) {
                    this.syncCached(iter.next());
                }
            }
        }
    }
}

