/*
 * Decompiled with CFR 0.152.
 */
package org.ktde.ee.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ktde.ee.layer.CollectionDto;
import org.ktde.ee.layer.ListDto;
import org.ktde.ee.layer.Mapper;
import org.ktde.ee.layer.MappingFactory;
import org.ktde.model.collections.AbstractCollectionModel;
import org.ktde.model.collections.ListModel;
import org.ktde.util.datatypes.ArrayListBag;
import org.ktde.util.datatypes.Bag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMappingFactory
implements MappingFactory {
    public static final Logger logger = LoggerFactory.getLogger(AbstractMappingFactory.class);
    private ConcurrentHashMap<Class<?>, Mapper<?, ?>> mapperMap = new ConcurrentHashMap();

    public abstract <T, U> Mapper<T, U> createMapperFor(Class<?> var1);

    public <T, U> Mapper<T, U> getMapperFor(Class<?> clazz) {
        Mapper<Object, Object> mapper = this.mapperMap.get(clazz);
        if (mapper == null) {
            mapper = this.createMapperFor(clazz);
            this.mapperMap.putIfAbsent(clazz, mapper);
            mapper = this.mapperMap.get(clazz);
            mapper.setMappingFactory(this);
        }
        return mapper;
    }

    @Override
    public <T, U> void fillObject(Class<?> clazz, T object, U target) {
        Mapper<T, U> mapper = null;
        mapper = this.getMapperFor(clazz);
        if (mapper == null) {
            logger.error("didn't find mapper for " + clazz);
        }
        assert (mapper != null);
        mapper.getCorrectMapper(object).fillObject(object, target);
    }

    @Override
    public <T, U> U transformObject(Class<?> clazz, T object) {
        Mapper<T, U> mapper = null;
        mapper = this.getMapperFor(clazz);
        if (mapper == null) {
            logger.error("didn't find mapper for " + clazz);
        }
        assert (mapper != null);
        U result = this.transformObject(mapper, object);
        return result;
    }

    protected <T, U> U transformObject(Mapper<T, U> mapper, T object) {
        Mapper<T, U> corrected = mapper.getCorrectMapper(object);
        U result = corrected.createInstance(object);
        corrected.fillObject(object, result);
        return result;
    }

    public <U> List<U> createListInstance() {
        return new ArrayList();
    }

    @Override
    public <T, U> List<U> transformList(Class<?> clazz, List<T> list) {
        List<U> result = this.createListInstance();
        this.transformCollection(clazz, list, result);
        return result;
    }

    public <U> Set<U> createSetInstance() {
        return new HashSet();
    }

    @Override
    public <T, U> Set<U> transformSet(Class<?> clazz, Set<T> set) {
        Set<U> result = this.createSetInstance();
        this.transformCollection(clazz, set, result);
        return result;
    }

    public <U> Bag<U> createBagInstance() {
        return new ArrayListBag();
    }

    @Override
    public <T, U> Bag<U> transformBag(Class<?> clazz, Bag<T> bag) {
        Bag<U> result = this.createBagInstance();
        this.transformCollection(clazz, bag, result);
        return result;
    }

    protected <T, U> void transformCollection(Class<?> clazz, Collection<T> inCollection, Collection<U> outCollection) {
        if (!inCollection.isEmpty()) {
            Mapper<T, U> mapper = null;
            mapper = this.getMapperFor(clazz);
            if (mapper == null) {
                logger.error("didn't find mapper for " + clazz);
            }
            assert (mapper != null);
            for (T t : inCollection) {
                U target = this.transformObject(mapper, t);
                if (outCollection instanceof AbstractCollectionModel) {
                    AbstractCollectionModel c = (AbstractCollectionModel)outCollection;
                    c.append(target);
                    continue;
                }
                outCollection.add(target);
            }
        }
        if (outCollection instanceof AbstractCollectionModel && inCollection instanceof CollectionDto) {
            AbstractMappingFactory.transferFunctions((CollectionDto)inCollection, (AbstractCollectionModel)outCollection);
        }
    }

    public static void transferFunctions(CollectionDto<?> list, AbstractCollectionModel<?> result) {
        result.setCanAppendAnonymous(list.getCanAppendAnonymous());
        result.setCanAppendObject(list.getCanAppendObject());
        if (list instanceof ListDto && result instanceof ListModel) {
            ((ListModel)result).setCanDelete(((ListDto)list).getCanDelete());
            ((ListModel)result).setCanSet(((ListDto)list).getCanSet());
            ((ListModel)result).setCanEdit(((ListDto)list).getCanEdit());
        }
    }

    @Override
    public <T, U> U createInstance(Class<?> clazz, T object) {
        Mapper<T, U> mapper = null;
        mapper = this.getMapperFor(clazz);
        if (mapper == null) {
            logger.error("didn't find mapper for " + clazz);
        }
        assert (mapper != null);
        return mapper.getCorrectMapper(object).createInstance(object);
    }

    @Override
    public <T, U> Class<? extends U> getTargetClass(Class<?> clazz, T object) {
        Mapper<T, U> mapper = this.getMapperFor(clazz);
        return mapper.getCorrectMapper(object).getTargetClass(object);
    }

    @Override
    public <T, U> Collection<Class<?>> getParentClasses(Class<?> clazz, T object) {
        Mapper<T, U> mapper = this.getMapperFor(clazz);
        return mapper.getCorrectMapper(object).getParentClasses(object);
    }
}

