/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceHiLoGenerator
extends SequenceGenerator {
    public static final String MAX_LO = "max_lo";
    private static final Logger log = LoggerFactory.getLogger(SequenceHiLoGenerator.class);
    private int maxLo;
    private int lo;
    private long hi;
    private Class returnClass;

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, 9);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (this.maxLo < 1) {
            long val = ((Number)super.generate(session, obj)).longValue();
            if (val == 0L) {
                val = ((Number)super.generate(session, obj)).longValue();
            }
            return IdentifierGeneratorFactory.createNumber(val, this.returnClass);
        }
        if (this.lo > this.maxLo) {
            long hival = ((Number)super.generate(session, obj)).longValue();
            this.lo = hival == 0L ? 1 : 0;
            this.hi = hival * (long)(this.maxLo + 1);
            if (log.isDebugEnabled()) {
                log.debug("new hi value: " + hival);
            }
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }
}

