/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString(SEQUENCE, params, "hibernate_sequence");
        this.parameters = params.getProperty(PARAMETERS);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        if (this.sequenceName.indexOf(46) < 0) {
            this.sequenceName = Table.qualify(catalogName, schemaName, this.sequenceName);
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        try {
            Serializable serializable;
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet rs = st.executeQuery();
                try {
                    rs.next();
                    Serializable result = IdentifierGeneratorFactory.get(rs, this.identifierType);
                    if (log.isDebugEnabled()) {
                        log.debug("Sequence identifier generated: " + result);
                    }
                    serializable = result;
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            return serializable;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get next sequence value", this.sql);
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] ddl = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = ddl.length - 1;
            ddl[n] = ddl[n] + ' ' + this.parameters;
        }
        return ddl;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }
}

