/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Date;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.MeasurementRange;
import org.geotools.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRange
extends Range<Date> {
    private static final long serialVersionUID = -6400011350250757942L;
    private static final Unit<Duration> MILLISECOND = SI.MILLI(SI.SECOND);

    public DateRange(Date startTime, Date endTime) {
        super(Date.class, DateRange.clone(startTime), DateRange.clone(endTime));
    }

    public DateRange(Date startTime, boolean isMinIncluded, Date endTime, boolean isMaxIncluded) {
        super(Date.class, DateRange.clone(startTime), isMinIncluded, DateRange.clone(endTime), isMaxIncluded);
    }

    public DateRange(MeasurementRange<?> range, Date origin) throws ConversionException {
        this(range, DateRange.getConverter(range.getUnits()), origin.getTime());
    }

    private DateRange(MeasurementRange<?> range, UnitConverter converter, long origin) throws ConversionException {
        super(Date.class, new Date(origin + Math.round(converter.convert(range.getMinimum()))), range.isMinIncluded(), new Date(origin + Math.round(converter.convert(range.getMaximum()))), range.isMaxIncluded());
    }

    private static Date clone(Date date) {
        return date != null ? (Date)date.clone() : null;
    }

    private static UnitConverter getConverter(Unit<?> source) throws ConversionException {
        if (source == null) {
            throw new ConversionException(Errors.format(142));
        }
        return source.getConverterTo(MILLISECOND);
    }

    @Override
    public Date getMinValue() {
        return DateRange.clone((Date)super.getMinValue());
    }

    @Override
    public Date getMaxValue() {
        return DateRange.clone((Date)super.getMaxValue());
    }
}

