/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.ExternalMark;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextMark;
import org.geotools.styling.TextMarkImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Stroke;
import org.opengis.util.Cloneable;

public class MarkImpl
implements Mark,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.styling");
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private StrokeImpl stroke;
    private ExternalMarkImpl external;
    private Expression wellKnownName = null;
    private Expression rotation = null;
    private Expression size = null;

    public MarkImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
    }

    public MarkImpl(String name) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
        LOGGER.fine("creating " + name + " type mark");
        this.setWellKnownName(name);
    }

    public MarkImpl(FilterFactory filterFactory, ExternalMark external) {
        this.filterFactory = filterFactory;
        LOGGER.fine("creating defaultMark");
        try {
            StyleFactoryImpl sfac = new StyleFactoryImpl();
            this.fill = FillImpl.cast(sfac.getDefaultFill());
            this.stroke = StrokeImpl.cast(sfac.getDefaultStroke());
            this.wellKnownName = filterFactory.literal("square");
            this.size = filterFactory.literal(new Integer(6));
            this.rotation = filterFactory.literal(new Double(0.0));
        }
        catch (IllegalFilterException ife) {
            MarkImpl.severe("<init>", "Failed to build default mark: ", ife);
        }
        this.external = ExternalMarkImpl.cast(external);
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public FillImpl getFill() {
        return this.fill;
    }

    public StrokeImpl getStroke() {
        return this.stroke;
    }

    public Expression getWellKnownName() {
        return this.wellKnownName;
    }

    public void setFill(Fill fill) {
        this.fill = FillImpl.cast(fill);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = StrokeImpl.cast(stroke);
    }

    public void setSize(Expression size) {
        this.size = size;
    }

    public void setSize(int size) {
        this.setSize(this.filterFactory.literal(size));
    }

    public void setWellKnownName(Expression wellKnownName) {
        LOGGER.entering("DefaultMark", "setWellKnownName");
        this.wellKnownName = wellKnownName;
    }

    public void setWellKnownName(String name) {
        this.setWellKnownName(this.filterFactory.literal(name));
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    public void setRotation(double rotation) {
        this.setRotation(this.filterFactory.literal(rotation));
    }

    public Expression getSize() {
        return this.size;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public String toString() {
        return this.wellKnownName.toString();
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            MarkImpl clone = (MarkImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (FillImpl)this.fill.clone();
            }
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone MarkImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.wellKnownName != null) {
            result = 1000003 * result + this.wellKnownName.hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        MarkImpl other = (MarkImpl)oth;
        if (this.wellKnownName == null ? other.wellKnownName != null : !this.wellKnownName.equals(other.wellKnownName)) {
            return false;
        }
        if (this.rotation == null ? other.rotation != null : !this.rotation.equals(other.rotation)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    public ExternalMarkImpl getExternalMark() {
        return this.external;
    }

    public void setExternalMark(org.opengis.style.ExternalMark external) {
        this.external = ExternalMarkImpl.cast(external);
    }

    static MarkImpl cast(GraphicalSymbol item) {
        if (item == null) {
            return null;
        }
        if (item instanceof MarkImpl) {
            return (MarkImpl)item;
        }
        if (item instanceof TextMark) {
            TextMark text = (TextMark)item;
            TextMarkImpl copy = new TextMarkImpl();
            copy.setFill(text.getFill());
            copy.setRotation(text.getRotation());
            copy.setSize(text.getSize());
            copy.setStroke(text.getStroke());
            copy.setSymbol(text.getSymbol());
            copy.setWellKnownName(text.getWellKnownName());
            return copy;
        }
        if (item instanceof Mark) {
            Mark mark = (Mark)item;
            TextMarkImpl copy = new TextMarkImpl();
            copy.setFill(mark.getFill());
            copy.setRotation(mark.getRotation());
            copy.setSize(mark.getSize());
            copy.setStroke(mark.getStroke());
            ((MarkImpl)copy).setWellKnownName(mark.getWellKnownName());
            copy.setExternalMark(mark.getExternalMark());
            return copy;
        }
        return null;
    }
}

